/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import java.io.Serializable;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.geotools.api.feature.type.Name;
import org.geotools.dggs.gstore.DGGSGeometryStoreFactory;
import org.geotools.feature.NameImpl;

public class DGGSTestSupport
extends OGCApiTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setWorkspace(catalog.getDefaultWorkspace());
        DataStoreInfo ds = cb.buildDataStore("h3");
        ds.getConnectionParameters().put(DGGSGeometryStoreFactory.DGGS_FACTORY_ID.key, "H3");
        String nsURI = catalog.getDefaultNamespace().getURI();
        ds.getConnectionParameters().put(DGGSGeometryStoreFactory.NAMESPACE.key, nsURI);
        catalog.add((StoreInfo)ds);
        cb.setStore((StoreInfo)ds);
        FeatureTypeInfo ft = cb.buildFeatureType((Name)new NameImpl(nsURI, "H3"));
        cb.setupBounds((ResourceInfo)ft);
        DimensionInfoImpl time = new DimensionInfoImpl();
        time.setAttribute("date");
        ft.getMetadata().put("time", (Serializable)time);
        catalog.add((ResourceInfo)ft);
        LayerInfo li = cb.buildLayer(ft);
        catalog.add(li);
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setFeatureBounding(false);
        gs.save((ServiceInfo)wfs);
    }
}

