/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import com.thoughtworks.xstream.XStream;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.ogcapi.v1.dggs.DGGSInfo;
import org.geoserver.ogcapi.v1.dggs.DGGSInfoImpl;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.Version;
import org.springframework.stereotype.Component;

@Component
public class DGGSXStreamLoader
extends XStreamServiceLoader<DGGSInfo> {
    public DGGSXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "dggs");
    }

    public void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        super.initXStreamPersister(xp, gs);
        DGGSXStreamLoader.initXStreamPersister(xp);
    }

    public static void initXStreamPersister(XStreamPersister xp) {
        XStream xs = xp.getXStream();
        xs.alias("dggs", DGGSInfo.class, DGGSInfoImpl.class);
        xs.allowTypes(new Class[]{DGGSInfo.class});
    }

    protected DGGSInfo createServiceFromScratch(GeoServer gs) {
        DGGSInfoImpl dggs = new DGGSInfoImpl();
        dggs.setName("DGGS");
        return dggs;
    }

    public Class<DGGSInfo> getServiceClass() {
        return DGGSInfo.class;
    }

    protected DGGSInfo initialize(DGGSInfo service) {
        super.initialize((ServiceInfo)service);
        if (service.getVersions().isEmpty()) {
            service.getVersions().add(new Version("1.0.0"));
        }
        if (service.getTitle() == null) {
            service.setTitle("Discrete Global Grid Systems Service");
            service.setAbstract("OGCAPI-DGGS provides a spatial reference system that uses a hierarchical tessellation of cells to partition and address the globe.");
        }
        return service;
    }
}

