/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.images.ImagesTestSupport;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.util.IOUtils;
import org.geotools.util.URLs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class TransactionTest
extends ImagesTestSupport {
    protected static QName WATER_TEMP2 = new QName(MockData.SF_URI, "watertemp2", MockData.SF_PREFIX);

    @Before
    public void resetLayer() throws Exception {
        Resource watertemp2;
        CoverageInfo coverage = (CoverageInfo)this.getCatalog().getResourceByName(WATER_TEMP2.getLocalPart(), CoverageInfo.class);
        if (coverage != null) {
            this.getCatalog().remove((ResourceInfo)coverage);
            this.removeStore(coverage.getStore().getWorkspace().getName(), coverage.getStore().getName());
        }
        if ((watertemp2 = this.getDataDirectory().get(new String[]{"watertemp2"})).getType() == Resource.Type.DIRECTORY) {
            watertemp2.delete();
        }
        watertemp2.dir();
        try (ZipInputStream zis = new ZipInputStream(TransactionTest.class.getResourceAsStream("watertemp2.zip"));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = new File(watertemp2.dir(), zipEntry.getName());
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    IOUtils.copy((InputStream)zis, (OutputStream)fos);
                }
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        cb.setWorkspace(catalog.getWorkspaceByName(WATER_TEMP2.getPrefix()));
        CoverageStoreInfo store = cb.buildCoverageStore(WATER_TEMP2.getLocalPart());
        store.setURL(URLs.fileToUrl((File)watertemp2.dir()).toString());
        store.setType("ImageMosaic");
        catalog.add((StoreInfo)store);
        cb.setStore((StoreInfo)store);
        coverage = cb.buildCoverage("watertemp2");
        catalog.add((ResourceInfo)coverage);
        MatcherAssert.assertThat((Object)catalog.getCoverageByName(this.getLayerId(WATER_TEMP2)), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testResetState() throws Exception {
        String waterTemp2 = this.getLayerId(WATER_TEMP2);
        DocumentContext json = this.getAsJSONPath("ogc/images/v1/collections/" + waterTemp2 + "/images?f=" + ResponseUtils.urlEncode((String)"application/stac+json", (char[])new char[0]), 200);
        MatcherAssert.assertThat((Object)((Integer)json.read("features.size()", new Predicate[0])), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testUploadImagePost() throws Exception {
        String waterTemp2 = this.getLayerId(WATER_TEMP2);
        String fileName = "NCOM_wattemp_100_20081101T0000000_12.tiff";
        byte[] payload = this.getBytes(fileName);
        MockHttpServletResponse response = this.postAsServletResponse("ogc/images/v1/collections/" + waterTemp2 + "/images?filename=" + fileName, payload, "image/tiff");
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)201));
        MatcherAssert.assertThat((Object)response.getHeader("Location"), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp2/images/watertemp2.2"));
        DocumentContext json = this.getAsJSONPath("ogc/images/v1/collections/" + waterTemp2 + "/images/watertemp2.2?f=" + ResponseUtils.urlEncode((String)"application/stac+json", (char[])new char[0]), 200);
        MatcherAssert.assertThat((Object)((String)json.read("type", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"Feature"));
        MatcherAssert.assertThat((Object)((String)json.read("id", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"watertemp2.2"));
        MatcherAssert.assertThat((Object)((String)json.read("properties.datetime", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"2008-11-01T00:00:00Z"));
        MatcherAssert.assertThat((Object)((Integer)json.read("properties.elevation", new Predicate[0])), (Matcher)Matchers.equalTo((Object)100));
        MatcherAssert.assertThat((Object)((String)json.read("assets[0].href", new Predicate[0])), (Matcher)Matchers.endsWith((String)"NCOM_wattemp_100_20081101T0000000_12.tiff"));
    }

    @Test
    public void testDeleteImage() throws Exception {
        this.testUploadImagePost();
        String waterTemp2 = this.getLayerId(WATER_TEMP2);
        MockHttpServletResponse response = this.deleteAsServletResponse("ogc/images/v1/collections/" + waterTemp2 + "/images/watertemp2.2");
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        response = this.getAsServletResponse("ogc/images/v1/collections/" + waterTemp2 + "/images/watertemp2.2?f=" + ResponseUtils.urlEncode((String)"application/stac+json", (char[])new char[0]));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)404));
    }

    public byte[] getBytes(String file) throws IOException {
        byte[] payload = null;
        try (InputStream is = TransactionTest.class.getResourceAsStream(file);){
            payload = IOUtils.toByteArray((InputStream)is);
        }
        return payload;
    }
}

