/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.util.List;
import org.geoserver.ogcapi.v1.images.ImagesTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CollectionTest
extends ImagesTestSupport {
    @Test
    public void testWaterTempCollectionJson() throws Exception {
        String waterTemp = this.getLayerId(WATER_TEMP);
        DocumentContext json = this.getAsJSONPath("ogc/images/v1/collections/" + waterTemp, 200);
        this.testWaterTempCollectionJson(json);
    }

    @Test
    public void testWaterTempCollectionHTML() throws Exception {
        String waterTemp = this.getLayerId(WATER_TEMP);
        this.getAsJSoup("ogc/images/v1/collections/" + waterTemp + "?f=text/html");
    }

    protected void testWaterTempCollectionJson(DocumentContext json) {
        Assert.assertEquals((Object)"sf:watertemp", (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"Water temperature", (Object)json.read("$.title", String.class, new Predicate[0]));
        Assert.assertEquals((double)0.23722069, (double)((Double)json.read("$.extent.spatial.bbox[0][0]", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)40.56208, (double)((Double)json.read("$.extent.spatial.bbox[0][1]", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)14.592757, (double)((Double)json.read("$.extent.spatial.bbox[0][2]", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)44.558083, (double)((Double)json.read("$.extent.spatial.bbox[0][3]", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)json.read("$.extent.spatial.crs", String.class, new Predicate[0]));
        List items = (List)json.read("$.links[?(@.rel=='images')].href", new Predicate[0]);
        MatcherAssert.assertThat((Object)items.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)items, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images?f=application%2Fstac%2Bjson", "http://localhost:8080/geoserver/ogc/images/v1/collections/sf%3Awatertemp/images?f=text%2Fhtml"}));
    }

    @Test
    public void testImagesCollectionYaml() throws Exception {
        String waterTemp = this.getLayerId(WATER_TEMP);
        String yaml = this.getAsString("ogc/images/v1/collections/" + waterTemp + "?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testWaterTempCollectionJson((DocumentContext)json);
    }

    @Test
    public void testWorkspacedWaterTempCollectionJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("gs/ogc/images/v1/collections/" + WATER_TEMP_DEFAULT.getLocalPart(), 200);
        List items = (List)json.read("$.links[?(@.rel=='images')].href", new Predicate[0]);
        MatcherAssert.assertThat((Object)items.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)items, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"http://localhost:8080/geoserver/gs/ogc/images/v1/collections/watertemp/images?f=application%2Fstac%2Bjson", "http://localhost:8080/geoserver/gs/ogc/images/v1/collections/watertemp/images?f=text%2Fhtml"}));
    }
}

