/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import java.io.File;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;

@Component
class AssetHasher {
    AssetHasher() {
    }

    public boolean matches(File file, String hash) {
        String actualHash = this.hashFile(file);
        return actualHash.equals(hash);
    }

    public String hashFile(File file) {
        try {
            String canonicalPath = file.getCanonicalPath();
            String mainFilePath = FilenameUtils.getPath((String)canonicalPath);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(mainFilePath.getBytes());
            return Hex.encodeHexString((byte[])md.digest()) + "-" + file.getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

