/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.v1.images.ImagesCollectionsDocument;
import org.geoserver.ogcapi.v1.images.ImagesTestSupport;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;

public class CollectionsTest
extends ImagesTestSupport {
    @Test
    public void testCollectionsJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/images/v1/collections", 200);
        this.testCollectionsJson(json, MediaType.APPLICATION_JSON);
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/images/v1/collections/?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testCollectionsJson((DocumentContext)json, MediaType.parseMediaType((String)"application/yaml"));
    }

    private void testCollectionsJson(DocumentContext json, MediaType defaultFormat) throws Exception {
        int expected = (int)this.getStructuredCoverages().count();
        Assert.assertEquals((long)expected, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        List formats = ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)GeoServerSystemTestSupport.applicationContext)).getProducibleMediaTypes(ImagesCollectionsDocument.class, true);
        MatcherAssert.assertThat((Object)formats.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Integer)json.read("collections[0].links.length()", Integer.class, new Predicate[0]))));
        for (MediaType format : formats) {
            List items = (List)json.read("collections[0].links[?(@.type=='" + format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            if (defaultFormat.equals((Object)format)) {
                Assert.assertEquals((Object)"self", item.get("rel"));
                continue;
            }
            Assert.assertEquals((Object)"alternate", item.get("rel"));
        }
        Assert.assertEquals((long)1L, (long)((List)json.read("collections[?(@.id=='sf:watertemp')]", List.class, new Predicate[0])).size());
        Assert.assertEquals((Object)"Water temperature", (Object)this.readSingle(json, "collections[?(@.id=='sf:watertemp')].title"));
        Assert.assertEquals((Object)"I love my water warm and cosy!", (Object)this.readSingle(json, "collections[?(@.id=='sf:watertemp')].description"));
    }

    @Test
    public void testCollectionsHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/images/v1/collections?f=html");
        this.getStructuredCoverages().map(c -> c.prefixedName()).forEach(id -> {
            String htmlId = id.replace(":", "__");
            Assert.assertNotNull((Object)document.select("#html_" + htmlId + "_link"));
            Assert.assertEquals((Object)("http://localhost:8080/geoserver/ogc/images/v1/collections/" + ResponseUtils.urlEncode((String)id, (char[])new char[0]) + "?f=text%2Fhtml"), (Object)document.select("#html_" + htmlId + "_link").attr("href"));
        });
        CoverageInfo waterTemp = this.getCatalog().getCoverageByName(this.getLayerId(WATER_TEMP));
        String waterTempName = waterTemp.prefixedName().replace(":", "__");
        Assert.assertEquals((Object)"Water temperature", (Object)document.select("#" + waterTempName + "_title").text());
        Assert.assertEquals((Object)"I love my water warm and cosy!", (Object)document.select("#" + waterTempName + "_description").text());
    }
}

