/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import java.io.IOException;
import java.util.List;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.ogcapi.v1.images.ImageListener;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.gce.imagemosaic.Utils;

class ImageListenerSupport {
    private final List<ImageListener> imageListeners;

    public ImageListenerSupport(List<ImageListener> imageListeners) {
        this.imageListeners = imageListeners;
    }

    void imageAdded(CoverageInfo coverageInfo, GranuleSource granules, String featureId) throws IOException {
        SimpleFeatureCollection fc = granules.getGranules(new Query(coverageInfo.getNativeCoverageName(), (Filter)Utils.FF.id(new FeatureId[]{Utils.FF.featureId(featureId)})));
        SimpleFeature feature = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        if (feature != null && this.imageListeners != null) {
            for (ImageListener listener : this.imageListeners) {
                listener.imageAdded(coverageInfo, feature);
            }
        }
    }

    void imageRemoved(CoverageInfo coverageInfo, SimpleFeature feature) {
        if (feature != null && this.imageListeners != null) {
            for (ImageListener listener : this.imageListeners) {
                listener.imageRemoved(coverageInfo, feature);
            }
        }
    }
}

