/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.images;

import com.google.common.collect.Streams;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.OpenAPIBuilder;
import org.geoserver.ogcapi.v1.images.ImagesCollectionDocument;
import org.geoserver.ogcapi.v1.images.ImagesCollectionsDocument;
import org.geoserver.ogcapi.v1.images.ImagesService;
import org.geoserver.ogcapi.v1.images.ImagesServiceInfo;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpStatus;

public class ImagesAPIBuilder
extends OpenAPIBuilder<ImagesServiceInfo> {
    static final Logger LOGGER = Logging.getLogger(ImagesAPIBuilder.class);
    private final GeoServer geoServer;

    public ImagesAPIBuilder(GeoServer geoServer) {
        super(ImagesServiceInfo.class, "openapi.yaml", "Images API", ImagesService.class);
        this.geoServer = geoServer;
    }

    public OpenAPI build(ImagesServiceInfo service) throws IOException {
        OpenAPI api = super.build((ServiceInfo)service);
        this.declareGetResponseFormats(api, "/collections", ImagesCollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}", ImagesCollectionDocument.class);
        api.externalDocs(new ExternalDocumentation().description("Images specification").url("https://app.swaggerhub.com/apis/UAB-CREAF/ogc-api-images-opf-xml/1.0.0"));
        Map parameters = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)parameters.get("collectionId");
        boolean skipInvalid = this.geoServer.getGlobal().getResourceErrorHandling() == ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS;
        List validCollectionIds = Streams.stream(this.geoServer.getCatalog().getCoverages().iterator()).filter(c -> {
            try {
                return c.getGridCoverageReader(null, null) instanceof StructuredGridCoverage2DReader;
            }
            catch (IOException e) {
                if (skipInvalid) {
                    LOGGER.log(Level.WARNING, "Skipping coverage  " + c);
                    return false;
                }
                throw new APIException("InternalError", "Failed to iterate over the coverages in the catalog", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }).map(c -> c.prefixedName()).collect(Collectors.toList());
        collectionId.getSchema().setEnum(validCollectionIds);
        return api;
    }
}

