/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.v1.maps.CollectionsDocument;
import org.geoserver.ogcapi.v1.maps.MapsTestSupport;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;

public class CollectionsTest
extends MapsTestSupport {
    @Before
    public void revertChanges() throws IOException {
        this.revertLayer(MockData.BUILDINGS);
    }

    @Test
    public void testCollectionsJsonDefault() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections", 200);
        this.testCollectionsJson(json, MediaType.APPLICATION_JSON);
    }

    @Test
    public void testCollectionsJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections?f=json", 200);
        this.testCollectionsJson(json, MediaType.APPLICATION_JSON);
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/maps/v1/collections/?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testCollectionsJson((DocumentContext)json, MediaType.parseMediaType((String)"application/yaml"));
    }

    @Test
    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        FeatureTypeInfo misconfigured = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BUILDINGS));
        DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections", 200);
        Assert.assertEquals((long)37L, (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        misconfigured.setLatLonBoundingBox(null);
        this.getCatalog().save((ResourceInfo)misconfigured);
        DocumentContext json2 = this.getAsJSONPath("ogc/maps/v1/collections", 200);
        Assert.assertEquals((long)36L, (long)((Integer)json2.read("collections.length()", Integer.class, new Predicate[0])).intValue());
    }

    private void testCollectionsJson(DocumentContext json, MediaType defaultFormat) throws Exception {
        Assert.assertEquals((long)this.getNumberOfLayers(), (long)((Integer)json.read("collections.length()", Integer.class, new Predicate[0])).intValue());
        List formats = ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)GeoServerSystemTestSupport.applicationContext)).getProducibleMediaTypes(CollectionsDocument.class, true);
        formats.forEach(format -> {
            List items = (List)json.read("collections[0].links[?(@.type=='" + format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            if (defaultFormat.equals(format)) {
                Assert.assertEquals((Object)"self", item.get("rel"));
            } else {
                Assert.assertEquals((Object)"alternate", item.get("rel"));
            }
        });
    }

    @Test
    public void testCollectionsHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/maps/v1/collections?f=html");
        Assert.assertEquals((long)this.getNumberOfLayers(), (long)document.select("#content h2 a[href]").size());
    }

    @Test
    public void testVersionHeader() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/maps/v1/collections?f=html");
        Assert.assertTrue((boolean)this.headerHasValue(response, "API-Version", "1.0.1"));
    }

    private int getNumberOfLayers() {
        return this.getCatalog().getLayers().size();
    }
}

