/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.ogcapi.v1.maps.MapsTestSupport;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.junit.Test;

public class MapsTest
extends MapsTestSupport {
    @Test
    public void testDatetimeJson() throws Exception {
        this.setupStartEndTimeDimension(TIME_WITH_START_END, "time", "startTime", "endTime");
        Integer[] values = new Integer[]{1, 1, 1, 1, 0, 1};
        String[] dates = new String[]{"2012", "2012-02", "2012-02-11", "2012-02-11T00:00:00Z", "2012-02-14T00:00:00.000Z", "2012-02-12T00:00:00Z"};
        for (int i = 0; i < 6; ++i) {
            DocumentContext json = this.getAsJSONPath("ogc/maps/v1/collections/sf:TimeWithStartEnd/styles/Default/map/info?i=50&j=50&f=application%2Fjson&datetime=" + dates[i], 200);
            Assert.assertEquals((Object)values[i], (Object)json.read("$.numberReturned", Integer.class, new Predicate[0]));
        }
    }

    @Test
    public void testDatetimeHTMLMapsFormat() throws Exception {
        this.setupStartEndTimeDimension(TIME_WITH_START_END, "time", "startTime", "endTime");
        Document document = this.getAsJSoup("ogc/maps/v1/collections/sf:TimeWithStartEnd/styles/Default/map?f=html&datetime=2012-02-12T00:00:00Z");
        Assert.assertEquals((Object)"2012-02-12T00:00:00Z", (Object)MapsTest.getParameterValue(document, "datetime"));
    }

    @Test
    public void testHTMLNoDatetime() throws Exception {
        this.setupStartEndTimeDimension(TIME_WITH_START_END, "time", "startTime", "endTime");
        Document document = this.getAsJSoup("ogc/maps/v1/collections/sf:TimeWithStartEnd/styles/Default/map?f=html");
        Assert.assertNull((Object)MapsTest.getParameterValue(document, "datetime"));
    }

    private static String getParameterValue(Document document, String key) {
        Elements parameters = document.select("input[type='hidden'][title='" + key + "']");
        if (parameters.isEmpty()) {
            return null;
        }
        if (parameters.size() > 1) {
            Assert.fail((String)("Found more than one element with key " + key + ": " + parameters));
        }
        Element parameter = parameters.first();
        return parameter.attr("value");
    }
}

