/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import java.awt.Color;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.opengis.wfs.FeatureCollectionType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIBBoxParser;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.HTMLResponseBody;
import org.geoserver.ogcapi.v1.maps.CollectionDocument;
import org.geoserver.ogcapi.v1.maps.CollectionsDocument;
import org.geoserver.ogcapi.v1.maps.FeatureInfoResponse;
import org.geoserver.ogcapi.v1.maps.HTMLMap;
import org.geoserver.ogcapi.v1.maps.MapsLandingPage;
import org.geoserver.ogcapi.v1.maps.StylesDocument;
import org.geoserver.ows.kvp.TimeParser;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@APIService(service="Maps", version="1.0.1", landingPage="ogc/maps/v1", serviceClass=WMSInfo.class)
@RequestMapping(path={"ogc/maps/v1"})
public class MapsService {
    public static final String CONF_CLASS_CORE = "http://www.opengis.net/spec/ogcapi-maps-1/1.0/conf/core";
    public static final String CONF_CLASS_GEODATA = "http://www.opengis.net/spec/ogcapi-maps-1/1.0/conf/geodata";
    public static final String CONF_CLASS_BBOX = "http://www.opengis.net/spec/ogcapi-maps-2/1.0/conf/bbox";
    public static final String CONF_CLASS_CRS = "http://www.opengis.net/spec/ogcapi-maps-2/1.0/conf/crs";
    private static final String DISPLAY_NAME = "OGC API Maps";
    private TimeParser timeParser = new TimeParser();
    private final GeoServer geoServer;
    private final WebMapService wms;

    public MapsService(GeoServer geoServer, @Qualifier(value="wmsService2") WebMapService wms) {
        this.geoServer = geoServer;
        this.wms = wms;
    }

    public WMSInfo getService() {
        return (WMSInfo)this.geoServer.getService(WMSInfo.class);
    }

    public WMSInfo getServiceInfo() {
        return this.getService();
    }

    private Catalog getCatalog() {
        return this.geoServer.getCatalog();
    }

    @GetMapping(name="getLandingPage")
    @ResponseBody
    @HTMLResponseBody(templateName="landingPage.ftl", fileName="landingPage.html")
    public MapsLandingPage landingPage() {
        return new MapsLandingPage(this.getService(), this.getCatalog(), "ogc/maps/v1");
    }

    @GetMapping(path={"conformance"}, name="getConformanceDeclaration")
    @ResponseBody
    @HTMLResponseBody(templateName="conformance.ftl", fileName="conformance.html")
    public ConformanceDocument conformance() {
        List<String> classes = Arrays.asList("http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core", "http://www.opengis.net/spec/ogcapi-common-2/1.0/conf/collections", CONF_CLASS_CORE, CONF_CLASS_GEODATA, CONF_CLASS_BBOX, CONF_CLASS_CRS);
        return new ConformanceDocument(DISPLAY_NAME, classes);
    }

    @GetMapping(path={"collections"}, name="getCollections")
    @ResponseBody
    @HTMLResponseBody(templateName="collections.ftl", fileName="collections.html")
    public CollectionsDocument getCollections() {
        return new CollectionsDocument(this.geoServer);
    }

    @GetMapping(path={"collections/{collectionId}"}, name="describeCollection")
    @ResponseBody
    @HTMLResponseBody(templateName="collection.ftl", fileName="collection.html")
    public CollectionDocument collection(@PathVariable(name="collectionId") String collectionId) throws IOException {
        PublishedInfo p = this.getPublished(collectionId);
        CollectionDocument collection = new CollectionDocument(this.geoServer, p);
        return collection;
    }

    @GetMapping(path={"collections/{collectionId}/styles"}, name="getStyles")
    @ResponseBody
    @HTMLResponseBody(templateName="styles.ftl", fileName="styles.html")
    public StylesDocument styles(@PathVariable(name="collectionId") String collectionId) {
        PublishedInfo p = this.getPublished(collectionId);
        return new StylesDocument(p);
    }

    private PublishedInfo getPublished(String collectionId) {
        LayerInfo p = this.getCatalog().getLayerByName(collectionId);
        if (p == null) {
            if (collectionId.contains(":")) {
                String[] split = collectionId.split(":");
                p = this.getCatalog().getLayerGroupByName(split[0], split[1]);
            } else {
                p = this.getCatalog().getLayerGroupByName(collectionId);
            }
        }
        if (p == null) {
            throw new ServiceException("Unknown collection " + collectionId, "InvalidParameterValue", "collectionId");
        }
        return p;
    }

    @GetMapping(path={"collections/{collectionId}/styles/{styleId}/map"}, name="getCollectionMap")
    @ResponseBody
    public WebMap map(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="styleId") String styleId, @RequestParam(name="f") String format, @RequestParam(name="bbox", required=false) String bbox, @RequestParam(name="crs", required=false) String crs, @RequestParam(name="datetime", required=false) String datetime, @RequestParam(name="width", required=false) Integer width, @RequestParam(name="height", required=false) Integer height, @RequestParam(name="transparent", required=false, defaultValue="true") boolean transparent, @RequestParam(name="bgcolor", required=false) String bgcolor) throws IOException, FactoryException, ParseException {
        GetMapRequest request = this.toGetMapRequest(collectionId, styleId, format, bbox, crs, datetime, width, height, transparent, bgcolor);
        if ("text/html".equals(format) || "html".equals(format)) {
            DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)request);
            if (request.getCrs() != null) {
                request.setSRS(ResourcePool.lookupIdentifier((CoordinateReferenceSystem)request.getCrs(), (boolean)false));
            }
            request.getRawKvp().put("width", String.valueOf(request.getWidth()));
            request.getRawKvp().put("height", String.valueOf(request.getHeight()));
            if (height != null) {
                request.setHeight(height);
            }
            return new HTMLMap(new WMSMapContent(request));
        }
        return this.wms.reflect(request);
    }

    private List<MapLayerInfo> getMapLayers(PublishedInfo p) {
        if (p instanceof LayerGroupInfo) {
            return ((LayerGroupInfo)p).layers().stream().map(l -> new MapLayerInfo(l)).collect(Collectors.toList());
        }
        if (p instanceof LayerInfo) {
            return Arrays.asList(new MapLayerInfo((LayerInfo)p));
        }
        throw new RuntimeException("Unexpected published object" + p);
    }

    private void checkStyle(PublishedInfo p, String styleId) {
        if (p instanceof LayerGroupInfo && "_".equals(styleId)) {
            return;
        }
        if (p instanceof LayerInfo) {
            LayerInfo l = (LayerInfo)p;
            if (l.getDefaultStyle().prefixedName().equals(styleId) || l.getStyles().stream().anyMatch(s -> s.prefixedName().equals(styleId))) {
                return;
            }
        } else {
            throw new RuntimeException("Unexpected published object" + p);
        }
        throw new APIException("InvalidParameterValue", "Invalid style identifier: " + styleId, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(path={"collections/{collectionId}/styles/{styleId}/map/info"}, name="getCollectionInfo")
    @ResponseBody
    public FeatureInfoResponse info(@PathVariable(name="collectionId") String collectionId, @PathVariable(name="styleId") String styleId, @RequestParam(name="f") String format, @RequestParam(name="bbox", required=false) String bbox, @RequestParam(name="crs", required=false) String crs, @RequestParam(name="datetime", required=false) String datetime, @RequestParam(name="width", required=false) Integer width, @RequestParam(name="height", required=false) Integer height, @RequestParam(name="transparent", required=false, defaultValue="true") boolean transparent, @RequestParam(name="bgcolor", required=false) String bgcolor, @RequestParam(name="i") int i, @RequestParam(name="j") int j) throws IOException, FactoryException, ParseException {
        GetMapRequest getMapRequest = this.toGetMapRequest(collectionId, styleId, "image/png", bbox, crs, datetime, width, height, transparent, bgcolor);
        DefaultWebMapService.autoSetBoundsAndSize((GetMapRequest)getMapRequest);
        GetFeatureInfoRequest request = new GetFeatureInfoRequest();
        request.setGetMapRequest(getMapRequest);
        request.setXPixel(i);
        request.setYPixel(j);
        request.setInfoFormat(format);
        request.setQueryLayers(getMapRequest.getLayers());
        FeatureCollectionType collection = this.wms.getFeatureInfo(request);
        return new FeatureInfoResponse(collection, request);
    }

    private GetMapRequest toGetMapRequest(String collectionId, String styleId, String format, String bbox, String crs, String datetime, Integer width, Integer height, boolean transparent, String bgcolor) throws IOException, FactoryException, ParseException {
        PublishedInfo p = this.getPublished(collectionId);
        this.checkStyle(p, styleId);
        StyleInfo styleInfo = this.getCatalog().getStyleByName(styleId);
        GetMapRequest request = new GetMapRequest();
        request.setBaseUrl(APIRequestInfo.get().getBaseURL());
        request.setLayers(this.getMapLayers(p));
        if (styleInfo != null) {
            request.setStyles(Arrays.asList(styleInfo.getStyle()));
        }
        request.setFormat(format);
        if (bbox != null) {
            ReferencedEnvelope[] parsed = APIBBoxParser.parse((String)bbox, (String)crs);
            if (parsed.length > 1) {
                throw new APIException("InvalidParameterValue", "Cannot handle dateline crossing requests", HttpStatus.BAD_REQUEST);
            }
            ReferencedEnvelope envelope = parsed[0];
            request.setBbox((Envelope)envelope);
            request.setCrs(envelope.getCoordinateReferenceSystem());
        }
        if (width != null) {
            request.setWidth(width);
        }
        if (height != null) {
            request.setHeight(height);
        }
        if (bgcolor != null) {
            request.setBgColor(Color.decode(bgcolor));
        }
        request.setTransparent(transparent);
        if (datetime != null) {
            this.setupTimeSubset(datetime, p, request);
        }
        LinkedHashMap<String, String> rawParamers = new LinkedHashMap<String, String>();
        if (bbox != null) {
            rawParamers.put("bbox", bbox);
        }
        if (crs != null) {
            rawParamers.put("crs", crs);
        }
        rawParamers.put("width", String.valueOf(width));
        rawParamers.put("height", String.valueOf(height));
        rawParamers.put("layers", collectionId);
        rawParamers.put("styles", styleId);
        if (datetime != null) {
            rawParamers.put("datetime", datetime);
        }
        request.setRawKvp(rawParamers);
        return request;
    }

    private void setupTimeSubset(String datetime, PublishedInfo p, GetMapRequest request) throws ParseException {
        if (!(p instanceof LayerInfo)) {
            throw new APIException("InvalidParameterValue", "Can only handle time subset on layers, not layer groups", HttpStatus.BAD_REQUEST);
        }
        LayerInfo layer = (LayerInfo)p;
        DimensionInfo time = (DimensionInfo)layer.getResource().getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            throw new APIException("InvalidParameterValue", "Time dimension is not enabled in this coverage", HttpStatus.BAD_REQUEST);
        }
        Collection times = this.timeParser.parse(datetime);
        if (times.size() != 1) {
            throw new APIException("InvalidParameterValue", "Invalid datetime specification, must be a single time, or a time range", HttpStatus.BAD_REQUEST);
        }
        request.setTime(List.copyOf(times));
    }
}

