/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.ogcapi.MessageConverterResponseAdapter;
import org.geoserver.ogcapi.ResponseMessageConverter;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.wms.WebMap;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class MapResponseMessageConverter
extends MessageConverterResponseAdapter<WebMap>
implements ResponseMessageConverter<WebMap> {
    static final Logger LOGGER = Logging.getLogger(MapResponseMessageConverter.class);

    public MapResponseMessageConverter() {
        super(WebMap.class, WebMap.class);
    }

    protected void writeResponse(WebMap value, HttpOutputMessage httpOutputMessage, Operation operation, Response response) throws IOException {
        response.write((Object)value, httpOutputMessage.getBody(), operation);
    }

    protected Operation getOperation(WebMap result, Request dr, MediaType mediaType) {
        Operation original = dr.getOperation();
        return new Operation(original.getId(), original.getService(), original.getMethod(), new Object[]{result.getMapContent().getRequest()});
    }

    public List<MediaType> getSupportedMediaTypes(Class<?> valueClass, WebMap value) {
        if (!this.canWrite(valueClass, null)) {
            return Collections.emptyList();
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(this.getSupportedMediaTypes());
        if (value.getMimeType() != null) {
            result.add(MediaType.parseMediaType((String)value.getMimeType()));
        }
        return result;
    }

    public boolean canWrite(Object value, MediaType mediaType) {
        if (!(value instanceof WebMap)) {
            return false;
        }
        WebMap map = (WebMap)value;
        return this.getResponse(mediaType).isPresent() && (map.getMimeType() == null || MediaType.parseMediaType((String)map.getMimeType()).isCompatibleWith(mediaType));
    }
}

