/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.maps;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.StyleDocument;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.WebMap;
import org.springframework.http.MediaType;

@JsonPropertyOrder(value={"styles", "links"})
public class StylesDocument
extends AbstractDocument {
    private static final String REL_MAP = "map";
    private final PublishedInfo published;

    public StylesDocument(PublishedInfo published) {
        this.published = published;
        this.addSelfLinks("ogc/maps/v1/collections/" + ResponseUtils.urlEncode((String)published.prefixedName(), (char[])new char[0]) + "/styles");
    }

    public List<StyleDocument> getStyles() {
        return this.getStyleInfos().stream().map(this::toDocument).collect(Collectors.toList());
    }

    private StyleDocument toDocument(StyleInfo s) {
        StyleDocument result = s != null ? new StyleDocument(s) : new StyleDocument("_", "Default style for " + this.published.prefixedName());
        Collection formats = APIRequestInfo.get().getProducibleMediaTypes(WebMap.class, true);
        String baseUrl = APIRequestInfo.get().getBaseURL();
        String collectionId = ResponseUtils.urlEncode((String)this.published.prefixedName(), (char[])new char[0]);
        String styleId = s == null ? "_" : s.prefixedName();
        for (MediaType format : formats) {
            String apiUrl = ResponseUtils.buildURL((String)baseUrl, (String)("ogc/maps/v1/collections/" + collectionId + "/styles/" + ResponseUtils.urlEncode((String)styleId, (char[])new char[0]) + "/map"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String title = this.getTitle(s, format);
            result.addLink(new Link(apiUrl, REL_MAP, format.toString(), title, "items"));
        }
        return result;
    }

    private String getTitle(StyleInfo s, MediaType format) {
        String result = "Map for " + this.published.prefixedName();
        if (s != null) {
            result = result + " and style " + s.prefixedName();
        }
        result = result + " as " + format;
        return result;
    }

    private List<StyleInfo> getStyleInfos() {
        ArrayList<StyleInfo> result = new ArrayList<StyleInfo>();
        if (this.published instanceof LayerInfo) {
            LayerInfo layer = (LayerInfo)this.published;
            result.addAll(layer.getStyles());
            StyleInfo defaultStyle = layer.getDefaultStyle();
            if (!result.contains(defaultStyle)) {
                result.add(defaultStyle);
            }
        } else if (this.published instanceof LayerGroupInfo) {
            result.add(null);
        } else {
            throw new RuntimeException("Cannot extract styles from " + this.published);
        }
        return result;
    }

    @JsonIgnore
    public PublishedInfo getPublished() {
        return this.published;
    }
}

