/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ConformanceTest
extends OGCApiTestSupport {
    @Test
    public void testConformanceJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/processes/v1/conformance", 200);
        this.checkConformance(json);
    }

    private void checkConformance(DocumentContext json) {
        Assert.assertEquals((long)2L, (long)((Integer)json.read("$.length()", Integer.class, new Predicate[0])).intValue());
        MatcherAssert.assertThat((Object)((Iterable)json.read("$.conformsTo", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])this.getExpectedConformanceClasses()));
    }

    private String[] getExpectedConformanceClasses() {
        return new String[]{"http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core", "http://www.opengis.net/spec/ogcapi-common/1.0/req/oas30", "http://www.opengis.net/spec/ogcapi-processes-1/1.0/conf/core", "http://www.opengis.net/spec/ogcapi-processes-1/1.0/conf/ogc-process-description", "http://www.opengis.net/spec/ogcapi-processes-1/1.0/conf/html", "http://www.opengis.net/spec/ogcapi-processes-1/1.0/conf/json", "http://www.opengis.net/spec/ogcapi-processes-1/1.0/conf/kvp-execute", "http://www.opengis.net/spec/ogcapi-processes-1/1.0/conf/dismiss"};
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/processes/v1/conformance/?f=application/yaml");
        this.checkConformance((DocumentContext)this.convertYamlToJsonPath(yaml));
    }

    @Test
    public void testConformanceHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/processes/v1/conformance?f=text/html");
        Assert.assertEquals((Object)"GeoServer OGC API Processes Conformance", (Object)document.select("#title").text());
        List classes = document.select("#content li").stream().map(e -> e.text()).collect(Collectors.toList());
        MatcherAssert.assertThat(classes, (Matcher)Matchers.containsInAnyOrder((Object[])this.getExpectedConformanceClasses()));
    }
}

