/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import java.net.URL;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.v1.processes.AbstractExecutionTest;
import org.geoserver.wps.MonkeyProcess;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ExecutionGetTest
extends AbstractExecutionTest {
    @Test
    public void testGetExecutionCoverageValues() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("ogc/processes/v1/processes/gs:GetCoveragesValue/execution?name=" + this.getLayerId(SystemTestData.TASMANIA_DEM) + "&x=145.220&y=-41.504");
        JSONArray values = json.getJSONArray("values");
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)298, (Object)values.get(0));
    }

    @Test
    public void testGetExecutionInvalidInput() throws Exception {
        JSONObject json = (JSONObject)this.getAsJSON("ogc/processes/v1/processes/gs:GetCoveragesValue/execution?name=notAGrid&x=145.220&y=-41.504");
        Assert.assertEquals((Object)"NoApplicableCode", (Object)json.getString("type"));
        MatcherAssert.assertThat((Object)json.getString("title"), (Matcher)CoreMatchers.containsString((String)"Could not find coverage notAGrid"));
    }

    @Test
    public void testInputOutputMimeTypes() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/processes/v1/processes/JTS:buffer/execution?geom[type]=application/wkt&geom=POINT(0 0)&distance=10&capStyle=Square&response[f]=application/wkt");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/wkt", (Object)response.getContentType());
        Assert.assertEquals((Object)"POLYGON ((10 10, 10 -10, -10 -10, -10 10, 10 10))", (Object)response.getContentAsString());
    }

    @Test
    public void testBufferReferenceGML() throws Exception {
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        MockHttpServletResponse response = this.getAsServletResponse("ogc/processes/v1/processes/gs:BufferFeatureCollection/execution?features[href]=" + collectionURL.toExternalForm() + "&features[type]=text/xml; subtype=wfs-collection/1.1&distance=1000&response[f]=application/json");
        this.checkBufferCollectionJSON(response);
    }

    @Test
    public void testRectangularClip() throws Exception {
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.json");
        MockHttpServletResponse response = this.getAsServletResponse("ogc/processes/v1/processes/gs:RectangularClip/execution?features[href]=" + collectionURL.toExternalForm() + "&features[type]=application/json&clip=0,0,2,2&response[f]=application/json");
        this.checkRectangleClip(response);
    }

    @Test
    public void testCount() throws Exception {
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        MockHttpServletResponse response = this.getAsServletResponse("ogc/processes/v1/processes/gs:Count/execution?features[href]=" + collectionURL.toExternalForm() + "&features[type]=text/xml; subtype=wfs-collection/1.1");
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertEquals((Object)"2", (Object)response.getContentAsString());
    }

    @Test
    public void testBoundsDocument() throws Exception {
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        MockHttpServletResponse response = this.getAsServletResponse("ogc/processes/v1/processes/gs:Bounds/execution?features[href]=" + collectionURL.toExternalForm() + "&features[type]=text/xml; subtype=wfs-collection/1.1");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertArrayEquals((Object[])new Object[]{0.0, 0.0, 5.0, 5.0}, (Object[])json.getJSONArray("bbox").toArray());
        Assert.assertEquals((Object)"EPSG:4326", (Object)json.getString("crs"));
    }

    @Test
    public void testMultipleOutputs() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/processes/v1/processes/gs:MultiRaw/execution?id=theLiteral&binaryMimeType=application/zip");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertTrue((boolean)json.has("literal"));
        Assert.assertEquals((Object)"theLiteral", (Object)json.getString("literal"));
        Assert.assertTrue((boolean)json.has("text"));
        JSONObject text = json.getJSONObject("text");
        Assert.assertEquals((Object)"text/plain", (Object)text.getString("mediaType"));
        Assert.assertEquals((Object)"This is the raw text", (Object)text.getString("value"));
        Assert.assertTrue((boolean)json.has("binary"));
        JSONObject binary = json.getJSONObject("binary");
        Assert.assertEquals((Object)"application/zip", (Object)binary.getString("mediaType"));
        Assert.assertEquals((Object)new String(Base64.encodeBase64((byte[])new byte[100])), (Object)binary.getString("value"));
    }

    @Test
    public void testMultipleOutputsSelectTwo() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/processes/v1/processes/gs:MultiRaw/execution?id=theLiteral&binaryMimeType=application/zip&literal[include]=false");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertFalse((boolean)json.has("literal"));
        Assert.assertTrue((boolean)json.has("text"));
        JSONObject text = json.getJSONObject("text");
        Assert.assertEquals((Object)"text/plain", (Object)text.getString("mediaType"));
        Assert.assertEquals((Object)"This is the raw text", (Object)text.getString("value"));
        Assert.assertTrue((boolean)json.has("binary"));
        JSONObject binary = json.getJSONObject("binary");
        Assert.assertEquals((Object)"application/zip", (Object)binary.getString("mediaType"));
        Assert.assertEquals((Object)new String(Base64.encodeBase64((byte[])new byte[100])), (Object)binary.getString("value"));
    }

    @Test
    public void testMultipleOutputsSelectOne() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/processes/v1/processes/gs:MultiRaw/execution?id=text&binaryMimeType=application/zip&text[include]=true&binary[include]=false&literal[include]=false");
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertEquals((Object)"This is the raw text", (Object)response.getContentAsString());
    }

    @Test
    public void testAsync() throws Exception {
        MockHttpServletRequest request = this.createRequest("ogc/processes/v1/processes/gs:Monkey/execution?id=test123&response[f]=application/json");
        request.setMethod("GET");
        request.addHeader("Prefer", (Object)"respond-async");
        request.setContent(new byte[0]);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String location = response.getHeader("Location");
        MatcherAssert.assertThat((Object)location, (Matcher)CoreMatchers.startsWith((String)"http://localhost:8080/geoserver/ogc/processes/v1/jobs/"));
        String jobId = location.substring(location.lastIndexOf(47) + 1);
        Assert.assertNotNull((Object)jobId);
        MonkeyProcess.progress((String)"test123", (float)20.0f, (boolean)false);
        JSONObject statusObject = this.waitMonkey(jobId, Set.of("accepted", "running"), "running");
        Assert.assertEquals((long)11L, (long)statusObject.getInt("progress"));
        String geojson = this.getBody("states-FeatureCollection.json");
        SimpleFeatureCollection fc = null;
        try (GeoJSONReader reader = new GeoJSONReader(geojson);){
            fc = reader.getFeatures();
        }
        MonkeyProcess.exit((String)"test123", (SimpleFeatureCollection)fc, (boolean)false);
        statusObject = this.waitMonkey(jobId, Set.of("successful", "running"), "successful");
        Assert.assertEquals((long)100L, (long)statusObject.getInt("progress"));
        JSONObject firstLink = statusObject.getJSONArray("links").getJSONObject(0);
        Assert.assertEquals((Object)"application/json", (Object)firstLink.getString("type"));
        String resultsHref = firstLink.getString("href");
        Assert.assertEquals((Object)("http://localhost:8080/geoserver/ogc/processes/v1/jobs/" + jobId + "/results"), (Object)resultsHref);
        MockHttpServletResponse processOutput = this.getAsServletResponse("ogc/processes/v1/jobs/" + jobId + "/results");
        Assert.assertEquals((Object)"application/json", (Object)processOutput.getContentType());
        try (GeoJSONReader reader = new GeoJSONReader(processOutput.getContentAsString());){
            SimpleFeatureCollection rc = reader.getFeatures();
            Assert.assertEquals(MultiPolygon.class, (Object)((SimpleFeatureType)rc.getSchema()).getGeometryDescriptor().getType().getBinding());
            Assert.assertEquals((long)2L, (long)rc.size());
        }
    }

    @Test
    public void testAsyncDismiss() throws Exception {
        MockHttpServletRequest request = this.createRequest("ogc/processes/v1/processes/gs:Monkey/execution?id=test123&response[f]=application/json");
        request.setMethod("GET");
        request.addHeader("Prefer", (Object)"respond-async");
        request.setContent(new byte[0]);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String location = response.getHeader("Location");
        MatcherAssert.assertThat((Object)location, (Matcher)CoreMatchers.startsWith((String)"http://localhost:8080/geoserver/ogc/processes/v1/jobs/"));
        String jobId = location.substring(location.lastIndexOf(47) + 1);
        Assert.assertNotNull((Object)jobId);
        MonkeyProcess.progress((String)"test123", (float)20.0f, (boolean)false);
        JSONObject statusObject = this.waitMonkey(jobId, Set.of("accepted", "running"), "running");
        Assert.assertEquals((long)11L, (long)statusObject.getInt("progress"));
        String statusRef = "ogc/processes/v1/jobs/" + jobId;
        response = this.deleteAsServletResponse(statusRef);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject dismissStatus = (JSONObject)this.json(response);
        this.print((JSON)dismissStatus);
        Assert.assertEquals((Object)"dismissed", (Object)dismissStatus.getString("status"));
        MonkeyProcess.progress((String)"test123", (float)40.0f, (boolean)false);
        JSONObject status = (JSONObject)this.getAsJSON(statusRef);
        Assert.assertEquals((Object)"dismissed", (Object)status.getString("status"));
    }

    private JSONObject waitMonkey(String jobId, Set<String> acceptableStatuses, String waitForStatus) throws Exception {
        JSONObject statusObject;
        String status;
        String jobStatusRef = "ogc/processes/v1/jobs/" + jobId;
        do {
            statusObject = (JSONObject)this.getAsJSON(jobStatusRef);
            Assert.assertEquals((Object)"gs:Monkey", (Object)statusObject.getString("processID"));
            int progress = statusObject.getInt("progress");
            MatcherAssert.assertThat((Object)progress, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(100)), Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))}));
            status = statusObject.getString("status");
            Assert.assertTrue((String)("Found unexpected status: " + status), (boolean)acceptableStatuses.contains(status));
            Thread.sleep(20L);
        } while (!waitForStatus.equals(status));
        return statusObject;
    }
}

