/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.ogcapi.v1.processes.AbstractExecutionTest;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.util.Base64;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.MultiPolygon;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ExecutionPostTest
extends AbstractExecutionTest {
    @Test
    public void testPostExecutionCoverageValues() throws Exception {
        String body = this.getBody("ExecuteGetCoverageValuesDefaults.json");
        JSONObject json = (JSONObject)this.postAsJSON("ogc/processes/v1/processes/gs:GetCoveragesValue/execution", body, "application/json");
        JSONArray values = json.getJSONArray("values");
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)298, (Object)values.get(0));
    }

    @Test
    public void testGetExecutionInvalidInput() throws Exception {
        String body = this.getBody("ExecuteGetCoverageValuesInvalidName.json");
        JSONObject json = (JSONObject)this.postAsJSON("ogc/processes/v1/processes/gs:GetCoveragesValue/execution", body, "application/json");
        this.print((JSON)json);
        Assert.assertEquals((Object)"NoApplicableCode", (Object)json.getString("type"));
        MatcherAssert.assertThat((Object)json.getString("title"), (Matcher)CoreMatchers.containsString((String)"Could not find coverage notAGrid"));
    }

    @Test
    public void testInputOutputMimeTypes() throws Exception {
        String body = this.getBody("ExecuteBufferWKT.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/JTS:buffer/execution", body, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/wkt", (Object)response.getContentType());
        Assert.assertEquals((Object)"POLYGON ((10 10, 10 -10, -10 -10, -10 10, 10 10))", (Object)response.getContentAsString());
    }

    @Test
    public void testBufferInlineGeoJSON() throws Exception {
        String body = this.getBody("ExecuteBufferGeoJSONRaw.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:BufferFeatureCollection/execution", body, "application/json");
        this.checkBufferCollectionJSON(response);
    }

    @Test
    public void testBufferInlineGML() throws Exception {
        String body = this.getBody("ExecuteBufferGMLRaw.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:BufferFeatureCollection/execution", body, "application/json");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        try (GeoJSONReader reader = new GeoJSONReader(response.getContentAsString());){
            SimpleFeatureCollection fc = reader.getFeatures();
            Assert.assertEquals(MultiPolygon.class, (Object)((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor().getType().getBinding());
            Assert.assertEquals((long)1L, (long)fc.size());
        }
    }

    @Test
    public void testBufferReferenceGML() throws Exception {
        String body = this.getBody("ExecuteBufferGMLReference.json");
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        body = body.replace("$LINK", collectionURL.toExternalForm());
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:BufferFeatureCollection/execution", body, "application/json");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        try (GeoJSONReader reader = new GeoJSONReader(response.getContentAsString());){
            SimpleFeatureCollection fc = reader.getFeatures();
            Assert.assertEquals(MultiPolygon.class, (Object)((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor().getType().getBinding());
            Assert.assertEquals((long)2L, (long)fc.size());
        }
    }

    @Test
    public void testContour() throws Exception {
        String body = this.getBody("ExecuteContourInternalReference.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:Contour/execution", body, "application/json");
        this.checkDEMContours(response);
    }

    @Test
    public void testRectangularClip() throws Exception {
        String body = this.getBody("ExecuteRectangularClip.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:RectangularClip/execution", body, "application/json");
        this.checkRectangleClip(response);
    }

    @Test
    public void testCountDocument() throws Exception {
        String body = this.getBody("ExecuteCountDocument.json");
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        body = body.replace("$LINK", collectionURL.toExternalForm());
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:Count/execution", body, "application/json");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertEquals((long)2L, (long)json.getInt("result"));
    }

    @Test
    public void testBoundsDocument() throws Exception {
        String body = this.getBody("ExecuteCountDocument.json");
        URL collectionURL = ((Object)((Object)this)).getClass().getResource("states-FeatureCollection.xml");
        body = body.replace("$LINK", collectionURL.toExternalForm());
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:Bounds/execution", body, "application/json");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        JSONObject bounds = json.getJSONObject("bounds");
        Assert.assertArrayEquals((Object[])new Object[]{0.0, 0.0, 5.0, 5.0}, (Object[])bounds.getJSONArray("bbox").toArray());
        Assert.assertEquals((Object)"EPSG:4326", (Object)bounds.getString("crs"));
    }

    @Test
    public void testCDataDocumentOutput() throws Exception {
        String body = this.getBody("ExecuteBufferWKTDocument.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/JTS:buffer/execution", body, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertTrue((boolean)json.has("result"));
        JSONObject result = json.getJSONObject("result");
        Assert.assertEquals((Object)"application/wkt", (Object)result.getString("mediaType"));
        Assert.assertEquals((Object)"POLYGON ((10 10, 10 -10, -10 -10, -10 10, 10 10))", (Object)result.getString("value"));
    }

    @Test
    public void testCDataDocumentInlineJSON() throws Exception {
        String body = this.getBody("ExecuteBufferJSONDocument.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/JTS:buffer/execution", body, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertTrue((boolean)json.has("result"));
        JSONObject result = json.getJSONObject("result");
        Assert.assertFalse((boolean)result.has("mediaType"));
        Assert.assertEquals((Object)"Polygon", (Object)result.getString("type"));
        Assert.assertEquals((Object)JSONArray.fromObject((Object)"[[[10,10],[10,-10],[-10,-10],[-10,10],[10,10]]]"), (Object)result.getJSONArray("coordinates"));
    }

    @Test
    public void testCDataDocumentJSONReference() throws Exception {
        String body = this.getBody("ExecuteBufferJSONReference.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/JTS:buffer/execution", body, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertTrue((boolean)json.has("result"));
        JSONObject result = json.getJSONObject("result");
        Assert.assertEquals((Object)"application/json", (Object)result.getString("mediaType"));
        Assert.assertTrue((boolean)result.has("href"));
        String href = result.getString("href");
        href = href.substring(href.indexOf(63) - 3);
        JSONObject reference = (JSONObject)this.getAsJSON(href);
        Assert.assertEquals((Object)"Polygon", (Object)reference.getString("type"));
        Assert.assertEquals((Object)JSONArray.fromObject((Object)"[[[10,10],[10,-10],[-10,-10],[-10,10],[10,10]]]"), (Object)reference.getJSONArray("coordinates"));
    }

    @Test
    public void testGMLDocumentInline() throws Exception {
        String body = this.getBody("ExecuteBufferGMLDocument.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/JTS:buffer/execution", body, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertTrue((boolean)json.has("result"));
        JSONObject result = json.getJSONObject("result");
        Assert.assertEquals((Object)"text/xml; subtype=gml/2.1.2", (Object)result.getString("mediaType"));
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><gml:Polygon xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates>10.0,10.0 10.0,-10.0 -10.0,-10.0 -10.0,10.0 10.0,10.0</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon>";
        Assert.assertEquals((Object)expected, (Object)result.getString("value"));
    }

    @Test
    public void testBinaryDocumentInline() throws Exception {
        String body = this.getBody("ExecuteBufferShapeZIPDocument.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:BufferFeatureCollection/execution", body, "application/json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertTrue((boolean)json.has("result"));
        JSONObject result = json.getJSONObject("result");
        Assert.assertEquals((Object)"application/zip", (Object)result.getString("mediaType"));
        byte[] bytes = Base64.decode((String)result.getString("value"));
        Set<String> actualNames = this.getZipFileNames(bytes);
        MatcherAssert.assertThat(actualNames, (Matcher)Matchers.hasItems((Object[])new String[]{"features.shp", "features.shx", "features.dbf"}));
    }

    private Set<String> getZipFileNames(byte[] bytes) throws IOException {
        HashSet<String> actualNames = new HashSet<String>();
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(bytes));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                actualNames.add(entry.getName());
                zis.closeEntry();
            }
        }
        return actualNames;
    }

    @Test
    public void testMultipleOutputs() throws Exception {
        String body = this.getBody("ExecuteMultipleOutputs.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:MultiRaw/execution", body, "application/json");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertTrue((boolean)json.has("text"));
        JSONObject text = json.getJSONObject("text");
        Assert.assertEquals((Object)"text/plain", (Object)text.getString("mediaType"));
        Assert.assertEquals((Object)"This is the raw text", (Object)text.getString("value"));
        Assert.assertTrue((boolean)json.has("binary"));
        JSONObject binary = json.getJSONObject("binary");
        Assert.assertEquals((Object)"application/zip", (Object)binary.getString("mediaType"));
        Assert.assertEquals((Object)new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])new byte[100])), (Object)binary.getString("value"));
    }

    @Test
    public void testMultipleOutputsSelection() throws Exception {
        String body = this.getBody("ExecuteMultipleOutputsSelection.json");
        MockHttpServletResponse response = this.postAsServletResponse("ogc/processes/v1/processes/gs:MultiRaw/execution", body, "application/json");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertTrue((boolean)json.has("text"));
        JSONObject text = json.getJSONObject("text");
        Assert.assertEquals((Object)"text/plain", (Object)text.getString("mediaType"));
        Assert.assertEquals((Object)"This is the raw text", (Object)text.getString("value"));
        Assert.assertFalse((boolean)json.has("binary"));
    }

    @Test
    public void testAsyncExecution() throws Exception {
        JSONObject statusObject;
        String status;
        String body = this.getBody("ExecuteBufferGeoJSONRaw.json");
        MockHttpServletRequest request = this.createRequest("ogc/processes/v1/processes/gs:BufferFeatureCollection/execution");
        request.setMethod("POST");
        request.setContentType("application/json");
        request.setContent(body.getBytes(StandardCharsets.UTF_8));
        request.addHeader("Prefer", (Object)"respond-async");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String location = response.getHeader("Location");
        MatcherAssert.assertThat((Object)location, (Matcher)CoreMatchers.startsWith((String)"http://localhost:8080/geoserver/ogc/processes/v1/jobs/"));
        String jobId = location.substring(location.lastIndexOf(47) + 1);
        Assert.assertNotNull((Object)jobId);
        String jobStatusRef = "ogc/processes/v1/jobs/" + jobId;
        do {
            statusObject = (JSONObject)this.getAsJSON(jobStatusRef);
            Assert.assertEquals((Object)"gs:BufferFeatureCollection", (Object)statusObject.getString("processID"));
            int progress = statusObject.getInt("progress");
            MatcherAssert.assertThat((Object)progress, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(100)), Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))}));
            status = statusObject.getString("status");
            MatcherAssert.assertThat((Object)status, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)"accepted"), (Matcher)Matchers.equalTo((Object)"running"), (Matcher)Matchers.equalTo((Object)"successful")));
            Thread.sleep(20L);
        } while (!"successful".equals(status));
        JSONObject firstLink = statusObject.getJSONArray("links").getJSONObject(0);
        Assert.assertEquals((Object)"application/json", (Object)firstLink.getString("type"));
        String resultsHref = firstLink.getString("href");
        Assert.assertEquals((Object)("http://localhost:8080/geoserver/ogc/processes/v1/jobs/" + jobId + "/results"), (Object)resultsHref);
        MockHttpServletResponse processOutput = this.getAsServletResponse(jobStatusRef + "/results");
        this.checkBufferCollectionJSON(processOutput);
    }
}

