/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.util.List;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.ogcapi.v1.processes.ProcessesService;
import org.geoserver.platform.Service;
import org.geoserver.wps.WPSInfo;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class LandingPageTest
extends OGCApiTestSupport {
    @Test
    public void testServiceDescriptor() {
        Service service = this.getService("Processes", new Version("1.0.0"));
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"Processes", (Object)service.getId());
        Assert.assertEquals((Object)new Version("1.0.0"), (Object)service.getVersion());
        MatcherAssert.assertThat((Object)service.getService(), (Matcher)CoreMatchers.instanceOf(ProcessesService.class));
        MatcherAssert.assertThat((Object)service.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"getLandingPage", "getApi", "getConformanceDeclaration", "getProcessList", "getProcessDescription", "executeProcessPOST", "executeProcessKVP", "getStatus", "getResults", "dismiss"}));
    }

    @Test
    public void testLandingPageNoSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/processes/v1", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageSlash() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/processes/v1/", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageJSON() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/processes/v1?f=json", 200);
        this.checkJSONLandingPage(json);
    }

    @Test
    public void testLandingPageYaml() throws Exception {
        String yaml = this.getAsString("ogc/processes/v1?f=application/yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.assertJSONList((DocumentContext)json, "links[?(@.type == 'application/yaml' && @.href =~ /.*ogc\\/processes\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList((DocumentContext)json, "links[?(@.type != 'application/yaml' && @.href =~ /.*ogc\\/processes\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared((DocumentContext)json);
    }

    @Test
    public void testLandingPageHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/processes/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/processes/v1/openapi?f=text%2Fhtml", (Object)document.select("#htmlApiLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/processes/v1/conformance?f=text%2Fhtml", (Object)document.select("#htmlConformanceLink").attr("href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/processes/v1/processes?f=text%2Fhtml", (Object)document.select("#htmlProcessesLink").attr("href"));
    }

    void checkJSONLandingPage(DocumentContext json) {
        Assert.assertEquals((long)12L, (long)((Integer)json.read("links.length()", Integer.class, new Predicate[0])).intValue());
        this.assertJSONList(json, "links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/processes\\/v1\\/\\?.*/)].rel", new String[]{"self"});
        this.assertJSONList(json, "links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/processes\\/v1\\/\\?.*/)].rel", new String[]{"alternate", "alternate"});
        this.checkJSONLandingPageShared(json);
    }

    void checkJSONLandingPageShared(DocumentContext json) {
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/processes\\/v1\\/openapi.*/)].rel", new String[]{"service-desc", "service-desc", "service-doc"});
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/processes/v1/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0", (Object)this.readSingle(json, "links[?(@.type=='application/vnd.oai.openapi+json;version=3.0')].href"));
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/processes\\/v1\\/conformance.*/)].rel", new String[]{"http://www.opengis.net/def/rel/ogc/1.0/conformance", "http://www.opengis.net/def/rel/ogc/1.0/conformance", "http://www.opengis.net/def/rel/ogc/1.0/conformance"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/processes\\/v1\\/processes.*/)].rel", new String[]{"http://www.opengis.net/def/rel/ogc/1.0/processes", "http://www.opengis.net/def/rel/ogc/1.0/processes", "http://www.opengis.net/def/rel/ogc/1.0/processes"});
        Assert.assertEquals((Object)"Processes 1.0 server", (Object)json.read("title", new Predicate[0]));
        Assert.assertEquals((Object)"", (Object)json.read("description", new Predicate[0]));
    }

    @Test
    public void testLandingPageHeaders() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/processes/v1", 200);
        List link = response.getHeaders("Link");
        MatcherAssert.assertThat((Object)link, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"<http://localhost:8080/geoserver/ogc/processes/v1/?f=application%2Fyaml>; rel=\"alternate\"; type=\"application/yaml\"; title=\"This document as application/yaml\"", "<http://localhost:8080/geoserver/ogc/processes/v1/?f=application%2Fjson>; rel=\"self\"; type=\"application/json\"; title=\"This document\""}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisabledService() throws Exception {
        GeoServer gs = this.getGeoServer();
        WPSInfo service = (WPSInfo)gs.getService(WPSInfo.class);
        service.setEnabled(false);
        gs.save((ServiceInfo)service);
        try {
            MockHttpServletResponse httpServletResponse = this.getAsMockHttpServletResponse("ogc/processes/v1", 404);
            Assert.assertEquals((Object)"Service Processes is disabled", (Object)httpServletResponse.getErrorMessage());
        }
        finally {
            service.setEnabled(true);
            gs.save((ServiceInfo)service);
        }
    }
}

