/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.wps.DeprecatedProcessFactory;
import org.geoserver.wps.ProcessGroupInfoImpl;
import org.geoserver.wps.WPSInfo;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.process.ProcessFactory;
import org.geotools.process.Processors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ProcessesTest
extends OGCApiTestSupport {
    @Test
    public void testProcessesJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/processes/v1/processes", 200);
        this.testProcessesJson(json, "application/json");
    }

    @Test
    public void testProcessesYaml() throws Exception {
        String yaml = this.getAsString("ogc/processes/v1/processes?f=yaml");
        JsonContext json = this.convertYamlToJsonPath(yaml);
        this.testProcessesJson((DocumentContext)json, "application/yaml");
    }

    private void testProcessesJson(DocumentContext json, String selfFormat) {
        Assert.assertEquals((Object)selfFormat, (Object)this.readSingle(json, "links[?(@.rel == 'self')].type"));
        String selfFormatEncoded = selfFormat.replace("/", "%2F");
        Assert.assertEquals((Object)("http://localhost:8080/geoserver/ogc/processes/v1/processes?f=" + selfFormatEncoded), (Object)this.readSingle(json, "links[?(@.rel == 'self')].href"));
        DocumentContext disjoint = this.readSingleContext(json, "processes[?(@.id == 'JTS:disjoint')]");
        Assert.assertEquals((Object)"1.0.0", (Object)disjoint.read("version", new Predicate[0]));
        Assert.assertEquals((Object)"Disjoint Test", (Object)disjoint.read("title", new Predicate[0]));
        Assert.assertEquals((Object)"Tests if two geometries do not have any points in common.", (Object)disjoint.read("description", new Predicate[0]));
        MatcherAssert.assertThat((Object)((Integer)json.read("processes.length()", Integer.class, new Predicate[0])), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcessSelection() throws Exception {
        List groups = Processors.getProcessFactories().stream().map(pf -> {
            ProcessGroupInfoImpl group = new ProcessGroupInfoImpl();
            group.setFactoryClass(pf.getClass());
            group.setEnabled(!(pf instanceof DeprecatedProcessFactory) && pf.getNames().stream().anyMatch(n -> "gs".equals(n.getNamespaceURI())));
            return group;
        }).collect(Collectors.toList());
        GeoServer gs = this.getGeoServer();
        WPSInfo wps = (WPSInfo)gs.getService(WPSInfo.class);
        wps.getProcessGroups().clear();
        wps.getProcessGroups().addAll(groups);
        gs.save((ServiceInfo)wps);
        try {
            DocumentContext json = this.getAsJSONPath("ogc/processes/v1/processes", 200);
            Assert.assertEquals((long)0L, (long)((List)json.read("processes[?(@.id == 'JTS:disjoint')].length()", List.class, new Predicate[0])).size());
            Assert.assertEquals((long)1L, (long)((List)json.read("processes[?(@.id == 'gs:GeorectifyCoverage')].length()", List.class, new Predicate[0])).size());
        }
        finally {
            wps.getProcessGroups().clear();
            gs.save((ServiceInfo)wps);
        }
    }

    @Test
    public void testProcessesHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/processes/v1/processes?f=html");
        NameImpl disjointName = new NameImpl("JTS", "disjoint");
        ProcessFactory jtsFactory = Processors.createProcessFactory((Name)disjointName);
        Assert.assertEquals((Object)jtsFactory.getTitle((Name)disjointName).toString(), (Object)document.select("#JTS__disjoint_title").text());
        Assert.assertEquals((Object)jtsFactory.getDescription((Name)disjointName).toString(), (Object)document.select("#JTS__disjoint_description").text());
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/processes/v1/processes/JTS:disjoint", (Object)document.selectFirst("a:contains(JTS:disjoint)").attr("href"));
    }
}

