/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wps10.ComplexDataType;
import net.opengis.wps10.DataInputsType1;
import net.opengis.wps10.DataType;
import net.opengis.wps10.DocumentOutputDefinitionType;
import net.opengis.wps10.ExecuteType;
import net.opengis.wps10.InputReferenceType;
import net.opengis.wps10.InputType;
import net.opengis.wps10.LiteralDataType;
import net.opengis.wps10.OutputDefinitionType;
import net.opengis.wps10.ResponseDocumentType;
import net.opengis.wps10.ResponseFormType;
import net.opengis.wps10.Wps10Factory;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.v1.processes.ExecuteOutput;
import org.geoserver.ogcapi.v1.processes.ExecuteRequest;
import org.geoserver.ogcapi.v1.processes.InputValue;
import org.geoserver.ogcapi.v1.processes.InputValueDeserializer;
import org.geoserver.ogcapi.v1.processes.Process;
import org.geoserver.ows.Ows11Util;
import org.geoserver.wps.ppio.BoundingBoxPPIO;
import org.geoserver.wps.ppio.ComplexPPIO;
import org.geoserver.wps.ppio.LiteralPPIO;
import org.geoserver.wps.ppio.ProcessParameterIO;
import org.geotools.api.data.Parameter;
import org.geotools.api.feature.type.Name;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;

public class ExecuteMapper {
    public static final String RESPONSE_FORMAT_KVP = "response[f]";
    public static final String LINK_HREF = "[href]";
    public static final String LINK_TYPE = "[type]";
    public static final String BBOX_CRS = "[crs]";
    public static final String INCLUDE = "[include]";
    private static final Wps10Factory WPS_FACTORY = Wps10Factory.eINSTANCE;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String HTTP_HEADER_PREFER = "Prefer";
    private final Process process;
    private final ApplicationContext context;

    ExecuteMapper(Process process, ApplicationContext context) {
        this.process = process;
        this.context = context;
    }

    ExecuteType mapToExecute(HttpServletRequest httpRequest, ExecuteRequest executeRequest) {
        String prefer;
        ExecuteType execute = WPS_FACTORY.createExecuteType();
        execute.setIdentifier(Ows11Util.code((Name)this.process.getName()));
        DataInputsType1 dataInputsType = WPS_FACTORY.createDataInputsType1();
        execute.setDataInputs(dataInputsType);
        for (Map.Entry<String, Parameter<?>> entry : this.process.getInputMap().entrySet()) {
            String inputName = entry.getKey();
            Parameter<?> parameter = entry.getValue();
            InputValue inputValue = executeRequest.getInputs().get(inputName);
            if (inputValue == null) {
                if (parameter.getMinOccurs() <= 0) continue;
                throw new APIException("InvalidParameterValue", "Missing required parameter: " + inputName, HttpStatus.BAD_REQUEST);
            }
            if (inputValue instanceof InputValue.ArrayInputValue) {
                InputValue.ArrayInputValue array = (InputValue.ArrayInputValue)inputValue;
                for (InputValue arrayEntry : array.getValues()) {
                    InputType inputType = this.getInputType(inputName, parameter, arrayEntry);
                    dataInputsType.getInput().add((Object)inputType);
                }
                continue;
            }
            InputType inputType = this.getInputType(inputName, parameter, inputValue);
            dataInputsType.getInput().add((Object)inputType);
        }
        Map<String, Parameter<?>> resultInfo = this.process.getResultInfo();
        if (executeRequest.getOutputs() != null) {
            Set<String> selectedOutputs = executeRequest.getOutputs().keySet();
            if (!resultInfo.keySet().containsAll(selectedOutputs)) {
                Set extraOutputs = selectedOutputs.stream().filter(outputName -> !resultInfo.containsKey(outputName)).collect(Collectors.toSet());
                throw new APIException("InvalidParameterValue", "Invalid output name(s): " + extraOutputs, HttpStatus.BAD_REQUEST);
            }
            resultInfo.keySet().removeIf(k -> !selectedOutputs.contains(k));
        }
        boolean async = (prefer = httpRequest.getHeader(HTTP_HEADER_PREFER)) != null && prefer.contains("respond-async");
        ResponseFormType responseForm = WPS_FACTORY.createResponseFormType();
        execute.setResponseForm(responseForm);
        if (resultInfo.size() > 1 || async) {
            ResponseDocumentType responseDocument = WPS_FACTORY.createResponseDocumentType();
            responseForm.setResponseDocument(responseDocument);
            responseDocument.setStatus(async);
            responseDocument.setStoreExecuteResponse(async);
            for (Map.Entry entry : resultInfo.entrySet()) {
                String outputName2 = (String)entry.getKey();
                Parameter result = (Parameter)entry.getValue();
                List encoders = ProcessParameterIO.findEncoder((Parameter)result, (ApplicationContext)this.context);
                if (encoders == null || encoders.isEmpty()) {
                    throw new APIException("NoApplicableCode", "Cannot handle response format for " + outputName2, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                DocumentOutputDefinitionType output = WPS_FACTORY.createDocumentOutputDefinitionType();
                output.setIdentifier(Ows11Util.code((String)outputName2));
                String mediaType = Optional.ofNullable(executeRequest.getOutputs()).map(outputs -> (ExecuteOutput)outputs.get(outputName2)).map(ExecuteOutput::getFormat).map(ExecuteOutput.ExecuteOutputFormat::getMediaType).orElse(null);
                if (mediaType != null) {
                    this.setResponseMediaType((OutputDefinitionType)output, resultInfo, mediaType);
                } else {
                    ProcessParameterIO encoder = (ProcessParameterIO)encoders.get(0);
                    if (encoder instanceof ComplexPPIO) {
                        output.setMimeType(((ComplexPPIO)encoder).getMimeType());
                    }
                }
                if (resultInfo.size() == 1 && executeRequest.getResponse() != ExecuteRequest.ResponseMode.DOCUMENT && async) {
                    responseDocument.setLineage(true);
                }
                ExecuteMapper.setupReference(executeRequest, output, outputName2);
                responseDocument.getOutput().add((Object)output);
            }
        } else {
            OutputDefinitionType output;
            String resultIdentifier = resultInfo.keySet().iterator().next();
            if (executeRequest.getResponse() == ExecuteRequest.ResponseMode.DOCUMENT) {
                DocumentOutputDefinitionType documentOutputDefinitionType = WPS_FACTORY.createDocumentOutputDefinitionType();
                ExecuteMapper.setupReference(executeRequest, documentOutputDefinitionType, resultIdentifier);
                output = documentOutputDefinitionType;
            } else {
                output = WPS_FACTORY.createOutputDefinitionType();
            }
            output.setIdentifier(Ows11Util.code((String)resultIdentifier));
            Optional.ofNullable(executeRequest.getOutputs()).map(outputs -> (ExecuteOutput)outputs.get(resultIdentifier)).map(ExecuteOutput::getFormat).map(ExecuteOutput.ExecuteOutputFormat::getMediaType).ifPresent(mt -> this.setResponseMediaType(output, resultInfo, (String)mt));
            if (executeRequest.getResponse() == ExecuteRequest.ResponseMode.RAW) {
                responseForm.setRawDataOutput(output);
            } else {
                ResponseDocumentType responseDocumentType = WPS_FACTORY.createResponseDocumentType();
                responseForm.setResponseDocument(responseDocumentType);
                responseDocumentType.getOutput().add((Object)output);
            }
        }
        execute.setBaseUrl(APIRequestInfo.get().getBaseURL());
        return execute;
    }

    private static void setupReference(ExecuteRequest request, DocumentOutputDefinitionType docOutput, String resultIdentifier) {
        docOutput.setAsReference(Optional.ofNullable(request.getOutputs()).map(outputs -> (ExecuteOutput)outputs.get(resultIdentifier)).map(o -> ExecuteOutput.TransmissionMode.REFERENCE.equals((Object)o.getTransmissionMode())).orElse(false).booleanValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputType getInputType(String inputName, Parameter<?> parameter, InputValue inputValue) {
        InputType inputType = WPS_FACTORY.createInputType();
        inputType.setIdentifier(Ows11Util.code((String)inputName));
        List ppios = ProcessParameterIO.findDecoder(parameter, (ApplicationContext)this.context);
        if (ppios.isEmpty()) {
            throw new IllegalArgumentException("Could not find process parameter for type " + parameter.key + "," + parameter.type);
        }
        if (inputValue instanceof InputValue.LiteralInputValue) {
            InputValue.LiteralInputValue literalValue = (InputValue.LiteralInputValue)inputValue;
            if (!(ppios.get(0) instanceof LiteralPPIO)) throw new RuntimeException("Unexpected situation, a literal should not map to a complex PPIO:" + literalValue);
            LiteralDataType literal = WPS_FACTORY.createLiteralDataType();
            literal.setValue(literalValue.getString());
            DataType dataType = WPS_FACTORY.createDataType();
            inputType.setData(dataType);
            dataType.setLiteralData(literal);
            return inputType;
        } else if (inputValue instanceof InputValue.InlineFileInputValue) {
            InputValue.InlineFileInputValue fileValue = (InputValue.InlineFileInputValue)inputValue;
            ComplexPPIO ppio = this.lookupPPIO(inputName, (List<ProcessParameterIO>)ppios, fileValue.getMediaType());
            ComplexDataType complex = ExecuteMapper.getComplexInlineDataType(WPS_FACTORY, ppio, fileValue.getValue());
            DataType dataType = WPS_FACTORY.createDataType();
            inputType.setData(dataType);
            dataType.setComplexData(complex);
            return inputType;
        } else if (inputValue instanceof InputValue.ReferenceInputValue) {
            InputValue.ReferenceInputValue referenceValue = (InputValue.ReferenceInputValue)inputValue;
            ComplexPPIO ppio = this.lookupPPIO(inputName, (List<ProcessParameterIO>)ppios, referenceValue.getType());
            InputReferenceType reference = ExecuteMapper.getRefenceType(WPS_FACTORY, ppio, referenceValue.getHref());
            inputType.setReference(reference);
            return inputType;
        } else if (inputValue instanceof InputValue.ComplexJSONInputValue) {
            InputValue.ComplexJSONInputValue complexValue = (InputValue.ComplexJSONInputValue)inputValue;
            ComplexPPIO ppio = this.lookupPPIO(inputName, (List<ProcessParameterIO>)ppios, (String mime) -> mime.startsWith("application/") && mime.contains("json"));
            String json = complexValue.getValue().toString();
            ComplexDataType complex = ExecuteMapper.getComplexInlineDataType(WPS_FACTORY, ppio, json);
            DataType dataType = WPS_FACTORY.createDataType();
            inputType.setData(dataType);
            dataType.setComplexData(complex);
            return inputType;
        } else {
            if (!(inputValue instanceof InputValue.BoundingBoxInputValue)) throw new IllegalArgumentException("Cannot handle input value of type " + inputValue.getClass());
            InputValue.BoundingBoxInputValue bboxValue = (InputValue.BoundingBoxInputValue)inputValue;
            BoundingBoxType bboxType = Ows11Factory.eINSTANCE.createBoundingBoxType();
            bboxType.setLowerCorner(bboxValue.getLowerCorner());
            bboxType.setUpperCorner(bboxValue.getUpperCorner());
            bboxType.setCrs(bboxValue.getCrs());
            DataType dataType = WPS_FACTORY.createDataType();
            dataType.setBoundingBoxData(bboxType);
            inputType.setData(dataType);
        }
        return inputType;
    }

    private ComplexPPIO lookupPPIO(String inputName, List<ProcessParameterIO> ppios, String targetType) {
        return this.lookupPPIO(inputName, ppios, (String m) -> m.equalsIgnoreCase(targetType) || targetType == null);
    }

    private ComplexPPIO lookupPPIO(String inputName, List<ProcessParameterIO> ppios, Predicate<String> matcher) {
        List complexPPIOS = ppios.stream().filter(p -> p instanceof ComplexPPIO).map(p -> (ComplexPPIO)p).collect(Collectors.toList());
        if (complexPPIOS.isEmpty()) {
            throw new APIException("InvalidParameterValue", "Cannot find a reader for " + inputName + " no supported reader found in any format", HttpStatus.BAD_REQUEST);
        }
        for (ComplexPPIO complexPPIO : complexPPIOS) {
            if (!matcher.test(complexPPIO.getMimeType())) continue;
            return complexPPIO;
        }
        throw new APIException("InvalidParameterValue", "Cannot find a reader for " + inputName + ", supported formats are: " + complexPPIOS.stream().map(ComplexPPIO::getMimeType).filter(m -> m != null).distinct().collect(Collectors.joining(", ")), HttpStatus.BAD_REQUEST);
    }

    ExecuteType mapQueryStringToExecute(HttpServletRequest httpRequest) throws IOException {
        boolean async;
        ExecuteType execute = WPS_FACTORY.createExecuteType();
        execute.setIdentifier(Ows11Util.code((Name)this.process.getName()));
        DataInputsType1 dataInputsType = WPS_FACTORY.createDataInputsType1();
        execute.setDataInputs(dataInputsType);
        for (Map.Entry<String, Parameter<?>> entry : this.process.getInputMap().entrySet()) {
            ComplexDataType complex;
            ComplexPPIO complexPPIO;
            String inputName = entry.getKey();
            Parameter<?> parameter = entry.getValue();
            InputType inputType = WPS_FACTORY.createInputType();
            inputType.setIdentifier(Ows11Util.code((String)inputName));
            DataType dataType = WPS_FACTORY.createDataType();
            inputType.setData(dataType);
            List ppios = ProcessParameterIO.findDecoder(parameter, (ApplicationContext)this.context);
            if (ppios.isEmpty()) {
                throw new IllegalArgumentException("Could not find process parameter for type " + parameter.key + "," + parameter.type);
            }
            String type = httpRequest.getParameter(inputName + LINK_TYPE);
            String href = httpRequest.getParameter(inputName + LINK_HREF);
            if (href != null) {
                ComplexPPIO ppio = this.lookupPPIO(inputName, (List<ProcessParameterIO>)ppios, type);
                InputReferenceType reference = ExecuteMapper.getRefenceType(WPS_FACTORY, ppio, href);
                inputType.setReference(reference);
                inputType.setData(null);
                dataInputsType.getInput().add((Object)inputType);
                continue;
            }
            String value = httpRequest.getParameter(inputName);
            if (value == null) {
                if (parameter.getMinOccurs() <= 0) continue;
                throw new APIException("InvalidParameterValue", "Missing required parameter: " + inputName, HttpStatus.BAD_REQUEST);
            }
            if (type == null) {
                JsonNode arrayNode;
                if (parameter.getMaxOccurs() > 1 && (arrayNode = ExecuteMapper.parseIfJsonArray(value)) != null) {
                    InputValue.ArrayInputValue arrayInput = (InputValue.ArrayInputValue)new InputValueDeserializer().getInputValue(arrayNode);
                    for (InputValue arrayEntry : arrayInput.getValues()) {
                        InputType localInputType = this.getInputType(inputName, parameter, arrayEntry);
                        dataInputsType.getInput().add((Object)localInputType);
                    }
                    continue;
                }
                if (ppios.get(0) instanceof LiteralPPIO) {
                    LiteralDataType literal = WPS_FACTORY.createLiteralDataType();
                    literal.setValue(value);
                    dataType.setLiteralData(literal);
                } else if (ppios.get(0) instanceof BoundingBoxPPIO) {
                    BoundingBoxType bbox = Ows11Factory.eINSTANCE.createBoundingBoxType();
                    double[] coords = Arrays.stream(value.split("\\s*,\\s*")).mapToDouble(d -> Double.parseDouble(d)).toArray();
                    String crs = httpRequest.getParameter(inputName + BBOX_CRS);
                    bbox.setCrs(crs);
                    if (coords.length == 4) {
                        bbox.setLowerCorner(Arrays.asList(coords[0], coords[1]));
                        bbox.setUpperCorner(Arrays.asList(coords[2], coords[3]));
                        if (crs == null) {
                            bbox.setCrs("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
                        }
                    } else if (coords.length == 6) {
                        bbox.setLowerCorner(Arrays.asList(coords[0], coords[1], coords[2]));
                        bbox.setUpperCorner(Arrays.asList(coords[3], coords[4], coords[5]));
                        if (crs == null) {
                            bbox.setCrs("http://www.opengis.net/def/crs/OGC/0/CRS84h");
                        }
                    } else {
                        throw new APIException("InvalidParameterValue", "Invalid bounding box coordinates: " + value, HttpStatus.BAD_REQUEST);
                    }
                    dataType.setBoundingBoxData(bbox);
                } else {
                    complexPPIO = (ComplexPPIO)ppios.get(0);
                    complex = ExecuteMapper.getComplexInlineDataType(WPS_FACTORY, complexPPIO, value);
                    dataType.setComplexData(complex);
                }
            } else {
                complexPPIO = this.lookupPPIO(inputName, (List<ProcessParameterIO>)ppios, type);
                complex = ExecuteMapper.getComplexInlineDataType(WPS_FACTORY, complexPPIO, value);
                dataType.setComplexData(complex);
            }
            dataInputsType.getInput().add((Object)inputType);
        }
        Map<String, Parameter<?>> resultInfo = this.process.getResultInfo();
        ResponseFormType responseFormType = WPS_FACTORY.createResponseFormType();
        execute.setResponseForm(responseFormType);
        String responseFormat = httpRequest.getParameter(RESPONSE_FORMAT_KVP);
        resultInfo.keySet().removeIf(k -> Optional.ofNullable(httpRequest.getParameter(k + INCLUDE)).map("false"::equalsIgnoreCase).orElse(false));
        String prefer = httpRequest.getHeader(HTTP_HEADER_PREFER);
        boolean bl = async = prefer != null && prefer.contains("respond-async");
        if (resultInfo.size() > 1 || async) {
            if (!(responseFormat == null || resultInfo.size() == 1 && async)) {
                throw new APIException("InvalidParameterValue", "Cannot handle response format specification response[f] when a process has multiple outputs", HttpStatus.BAD_REQUEST);
            }
            ResponseDocumentType responseDocument = WPS_FACTORY.createResponseDocumentType();
            responseDocument.setStatus(async);
            responseDocument.setStoreExecuteResponse(async);
            responseFormType.setResponseDocument(responseDocument);
            for (Map.Entry<String, Parameter<?>> entry : resultInfo.entrySet()) {
                String outputName = entry.getKey();
                Parameter<?> result = entry.getValue();
                List encoders = ProcessParameterIO.findEncoder(result, (ApplicationContext)this.context);
                if (encoders == null || encoders.isEmpty()) {
                    throw new APIException("NoApplicableCode", "Cannot handle response format for " + outputName, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                DocumentOutputDefinitionType output = WPS_FACTORY.createDocumentOutputDefinitionType();
                output.setIdentifier(Ows11Util.code((String)outputName));
                if (async && resultInfo.size() == 1 && responseFormat != null) {
                    this.setResponseMediaType((OutputDefinitionType)output, resultInfo, responseFormat);
                } else {
                    ProcessParameterIO encoder = (ProcessParameterIO)encoders.get(0);
                    if (encoder instanceof ComplexPPIO) {
                        output.setMimeType(((ComplexPPIO)encoder).getMimeType());
                    }
                }
                if (resultInfo.size() == 1 && async) {
                    responseDocument.setLineage(true);
                }
                responseDocument.getOutput().add((Object)output);
            }
        } else {
            OutputDefinitionType outputType = WPS_FACTORY.createOutputDefinitionType();
            outputType.setIdentifier(Ows11Util.code((String)resultInfo.keySet().iterator().next()));
            if (responseFormat != null && !responseFormat.isEmpty()) {
                this.setResponseMediaType(outputType, resultInfo, responseFormat);
            }
            responseFormType.setRawDataOutput(outputType);
        }
        execute.setBaseUrl(APIRequestInfo.get().getBaseURL());
        return execute;
    }

    private static JsonNode parseIfJsonArray(String input) {
        try {
            JsonNode node = OBJECT_MAPPER.readTree(input);
            if (node.isArray()) {
                return node;
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return null;
    }

    private static ComplexDataType getComplexInlineDataType(Wps10Factory wpsFactory, ComplexPPIO complexPPIO, String value) {
        ComplexDataType complex = wpsFactory.createComplexDataType();
        complex.setMimeType(complexPPIO.getMimeType());
        complex.getData().add((Object)value);
        return complex;
    }

    private static InputReferenceType getRefenceType(Wps10Factory wpsFactory, ComplexPPIO complexPPIO, String href) {
        InputReferenceType reference = wpsFactory.createInputReferenceType();
        reference.setMimeType(complexPPIO.getMimeType());
        reference.setHref(href);
        return reference;
    }

    private void setResponseMediaType(OutputDefinitionType outputType, Map<String, Parameter<?>> resultInfo, String responseFormat) {
        String[] formats = responseFormat.split("\\s*,\\s*");
        Set<String> formatsSet = Set.of(formats);
        Parameter<?> result = resultInfo.values().iterator().next();
        List encoders = ProcessParameterIO.findEncoder(result, (ApplicationContext)this.context);
        for (ProcessParameterIO encoder : encoders) {
            ComplexPPIO complexEncoder;
            if (!(encoder instanceof ComplexPPIO) || !formatsSet.contains((complexEncoder = (ComplexPPIO)encoder).getMimeType())) continue;
            outputType.setMimeType(complexEncoder.getMimeType());
            return;
        }
        for (ProcessParameterIO encoder : encoders) {
            if (!(encoder instanceof LiteralPPIO) || !formatsSet.contains("text/plain") && !formatsSet.contains("application/json")) continue;
            return;
        }
        throw new APIException("InvalidParameterValue", "Cannot handle response format: " + responseFormat, HttpStatus.BAD_REQUEST);
    }
}

