/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;

public interface InputValue {

    public static class BoundingBoxInputValue
    implements InputValue {
        public List<Double> lowerCorner;
        public List<Double> upperCorner;
        public String crs;

        public List<Double> getLowerCorner() {
            return this.lowerCorner;
        }

        public List<Double> getUpperCorner() {
            return this.upperCorner;
        }

        public String getCrs() {
            return this.crs;
        }
    }

    public static class ReferenceInputValue
    implements InputValue {
        public String href;
        public String type;

        public String getHref() {
            return this.href;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class ComplexJSONInputValue
    implements InputValue {
        public JsonNode value;

        public JsonNode getValue() {
            return this.value;
        }
    }

    public static class InlineFileInputValue
    implements InputValue {
        public String value;
        public String mediaType;

        public String getValue() {
            return this.value;
        }

        public String getMediaType() {
            return this.mediaType;
        }
    }

    public static class ArrayInputValue
    implements InputValue {
        public List<InputValue> values = new ArrayList<InputValue>();

        public List<InputValue> getValues() {
            return this.values;
        }
    }

    public static class LiteralInputValue
    implements InputValue {
        public Object value;

        public Object getValue() {
            return this.value;
        }

        public String getString() {
            return this.value == null ? null : String.valueOf(this.value);
        }
    }
}

