/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.processes;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.v1.processes.JobControl;
import org.geoserver.ogcapi.v1.processes.Process;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProcessSummaryDocument
extends AbstractDocument {
    String version;
    String title;
    String description;
    List<JobControl> jobControlOptions = List.of(JobControl.SYNC, JobControl.ASYNC);
    List<String> keywords;

    public ProcessSummaryDocument(Process process) {
        this.id = process.getName().getURI();
        this.version = process.getVersion();
        this.title = process.getTitle();
        this.description = process.getDescription();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<JobControl> getJobControlOptions() {
        return this.jobControlOptions;
    }

    public void setJobControlOptions(List<JobControl> jobControlOptions) {
        this.jobControlOptions = jobControlOptions;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProcessSummaryDocument that = (ProcessSummaryDocument)((Object)o);
        return Objects.equals(this.version, that.version) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && Objects.equals(this.jobControlOptions, that.jobControlOptions) && Objects.equals(this.keywords, that.keywords);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.version, this.title, this.description, this.jobControlOptions, this.keywords);
    }
}

