/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.ogcapi.v1.styles.StylesTestSupport;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ConformanceTest
extends StylesTestSupport {
    @Test
    public void testConformanceJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/conformance", 200);
        this.checkConformance(json);
    }

    private void checkConformance(DocumentContext json) {
        Assert.assertEquals((long)2L, (long)((Integer)json.read("$.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)json.read("$.conformsTo.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/core", (Object)json.read("$.conformsTo[0]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/html", (Object)json.read("$.conformsTo[1]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/json", (Object)json.read("$.conformsTo[2]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/mapbox-styles", (Object)json.read("$.conformsTo[3]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/sld-10", (Object)json.read("$.conformsTo[4]", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/sld-11", (Object)json.read("$.conformsTo[5]", String.class, new Predicate[0]));
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/styles/v1/conformance/?f=application/yaml");
        this.checkConformance((DocumentContext)this.convertYamlToJsonPath(yaml));
    }

    @Test
    public void testConformanceHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/styles/v1/conformance?f=text/html");
        Assert.assertEquals((Object)"GeoServer OGC API Styles Conformance", (Object)document.select("#title").text());
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/core", (Object)document.select("#content li:eq(0)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/html", (Object)document.select("#content li:eq(1)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/json", (Object)document.select("#content li:eq(2)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/mapbox-styles", (Object)document.select("#content li:eq(3)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/sld-10", (Object)document.select("#content li:eq(4)").text());
        Assert.assertEquals((Object)"http://www.opengis.net/t15/opf-styles-1/1.0/conf/sld-11", (Object)document.select("#content li:eq(5)").text());
    }
}

