/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.v1.styles.StylesTestSupport;
import org.geotools.image.test.ImageAssert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class StyleThumbnailTest
extends StylesTestSupport {
    public static final String BUILDINGS_LAKES = "buildingsLakes";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle(BUILDINGS_LAKES, "buildingsLakes.sld", StyleThumbnailTest.class, this.getCatalog());
    }

    @Test
    public void testThumbnailLakes() throws Exception {
        BufferedImage image = this.getAsImage("ogc/styles/v1/styles/Lakes/thumbnail", "image/png");
        ImageAssert.assertEquals((File)new File("./src/test/resources/thumbnails/lakes.png"), (RenderedImage)image, (int)0);
    }

    @Test
    public void testThumbnailLakesLink() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/Lakes/metadata", 200);
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, "links[?(@.rel=='preview')].href")), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/Lakes/thumbnail?f=image%2Fpng"));
    }

    @Test
    public void testThumbnailBuildingLakes() throws Exception {
        BufferedImage image = this.getAsImage("ogc/styles/v1/styles/buildingsLakes/thumbnail", "image/png");
        ImageAssert.assertEquals((File)new File("./src/test/resources/thumbnails/buildingsLakes.png"), (RenderedImage)image, (int)0);
    }

    @Test
    public void testThumbnailBuildingLakesLink() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/buildingsLakes/metadata", 200);
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, "links[?(@.rel=='preview')].href")), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/buildingsLakes/thumbnail?f=image%2Fpng"));
    }

    @Test
    public void testThumbnailPolygonCommentNoLink() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/PolygonComment/metadata", 200);
        List items = (List)json.read("[?(@.links.rel=='preview')]", new Predicate[0]);
        MatcherAssert.assertThat((Object)items.isEmpty(), (Matcher)Matchers.equalTo((Object)true));
    }
}

