/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.geoserver.ogcapi.v1.styles.StylesTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StylesTest
extends StylesTestSupport {
    @Test
    public void testStylesHTML() throws Exception {
        this.getAsJSoup("ogc/styles/v1/styles?f=html");
    }

    @Test
    public void testStylesJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles", 200);
        this.testStylesJson(json);
    }

    private void testStylesJson(DocumentContext json) {
        Assert.assertEquals((Object)"self", (Object)this.readSingle(json, "links[?(@.type == 'application/json')].rel"));
        Assert.assertEquals((Object)"alternate", (Object)this.readSingle(json, "links[?(@.type == 'application/yaml')].rel"));
        MatcherAssert.assertThat((Object)((List)json.read("styles[*].id", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"BasicPolygons", "BasicStyleGroupStyle", "Bridges", "Buildings", "Default", "DividedRoutes", "Forests", "Lakes", "MapNeatline", "NamedPlaces", "PolygonComment", "Ponds", "RoadSegments", "Streams", "ws:NamedPlacesWS", "cssSample", "generic", "line", "point", "polygon", "raster"}));
        Assert.assertEquals((Object)"Default Styler", (Object)this.readSingle(json, "styles[?(@.id == 'Default')].title"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/Default?f=application%2Fvnd.ogc.sld%2Bxml", (Object)this.readSingle(json, "styles[?(@.id == 'Default')].links[?(@.rel == 'stylesheet' && @.type == 'application/vnd.ogc.sld+xml')].href"));
        Assert.assertFalse((boolean)this.exists(json, "styles[?(@.id == 'Default')].links[?(@.rel == 'stylesheet' && @.type == 'application/vnd.geoserver.geocss+css')]"));
    }
}

