/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import java.util.Collections;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.ogcapi.v1.styles.CollectionCallbackIntegrationTest;

public class StylesTestSupport
extends OGCApiTestSupport {
    protected static final String POLYGON_COMMENT = "PolygonComment";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        CatalogBuilder cb = new CatalogBuilder(catalog);
        for (FeatureTypeInfo ft : catalog.getResourcesByNamespace(CiteTestData.CITE_URI, FeatureTypeInfo.class)) {
            cb.setupBounds((ResourceInfo)ft);
            catalog.save((ResourceInfo)ft);
        }
        testData.addWorkspace("ws", "http://www.geoserver.org/ws", catalog);
        WorkspaceInfo ws = catalog.getWorkspaceByName("ws");
        testData.addStyle(ws, "NamedPlacesWS", "NamedPlaces.sld", SystemTestData.class, catalog);
        testData.addStyle(POLYGON_COMMENT, "polygonComment.sld", StylesTestSupport.class, catalog);
        testData.addStyle(null, "cssSample", "cssSample.css", StylesTestSupport.class, catalog, Collections.singletonMap(SystemTestData.StyleProperty.FORMAT, "css"));
        testData.addStyle("BasicStyleGroupStyle", "BasicStyleGroup.sld", CollectionCallbackIntegrationTest.class, this.getCatalog());
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        StyleInfo s = catalog.getStyleByName("BasicStyleGroupStyle");
        lg.setName("BasicStyleGroup");
        lg.getLayers().add(null);
        lg.getStyles().add(s);
        new CatalogBuilder(catalog).calculateLayerGroupBounds(lg);
        catalog.add(lg);
    }
}

