/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import java.awt.Color;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ColorMapEntry;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Halo;
import org.geotools.api.style.ImageOutline;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.OverlapBehavior;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.renderer.style.ExpressionExtractor;
import org.locationtech.jts.geom.Geometry;

public class StyleAttributeExtractor
extends FilterAttributeExtractor
implements StyleVisitor {
    boolean defaultGeometryUsed = false;
    boolean symbolizerGeometriesVisitEnabled = true;
    Map<PropertyName, Class<?>> propertyTypes = new LinkedHashMap();

    public StyleAttributeExtractor() {
    }

    public StyleAttributeExtractor(SimpleFeatureType featureType) {
        super(featureType);
    }

    public Set<PropertyName> getAttributes() {
        return Collections.unmodifiableSet(this.propertyNames);
    }

    public boolean isSymbolizerGeometriesVisitEnabled() {
        return this.symbolizerGeometriesVisitEnabled;
    }

    public void setSymbolizerGeometriesVisitEnabled(boolean symbolizerGeometriesVisitEnabled) {
        this.symbolizerGeometriesVisitEnabled = symbolizerGeometriesVisitEnabled;
    }

    public boolean getDefaultGeometryUsed() {
        return this.defaultGeometryUsed;
    }

    public void visit(Style style) {
        style.featureTypeStyles().forEach(ft -> ft.accept((StyleVisitor)this));
    }

    public void visit(Rule rule) {
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this, null);
        }
        rule.symbolizers().forEach(s -> s.accept((StyleVisitor)this));
    }

    public void visit(FeatureTypeStyle fts) {
        for (Rule rule : fts.rules()) {
            rule.accept((StyleVisitor)this);
        }
    }

    public void visit(Fill fill) {
        if (fill.getColor() != null) {
            fill.getColor().accept((ExpressionVisitor)this, Color.class);
        }
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept((StyleVisitor)this);
        }
        if (fill.getOpacity() != null) {
            fill.getOpacity().accept((ExpressionVisitor)this, Double.class);
        }
    }

    public void visit(Stroke stroke) {
        if (stroke.getColor() != null) {
            stroke.getColor().accept((ExpressionVisitor)this, Color.class);
        }
        if (stroke.getDashOffset() != null) {
            stroke.getDashOffset().accept((ExpressionVisitor)this, Double.class);
        }
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept((StyleVisitor)this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept((StyleVisitor)this);
        }
        if (stroke.getLineCap() != null) {
            stroke.getLineCap().accept((ExpressionVisitor)this, String.class);
        }
        if (stroke.getLineJoin() != null) {
            stroke.getLineJoin().accept((ExpressionVisitor)this, String.class);
        }
        if (stroke.getOpacity() != null) {
            stroke.getOpacity().accept((ExpressionVisitor)this, Double.class);
        }
        if (stroke.getWidth() != null) {
            stroke.getWidth().accept((ExpressionVisitor)this, Double.class);
        }
        if (stroke.dashArray() != null) {
            for (Expression expression : stroke.dashArray()) {
                expression.accept((ExpressionVisitor)this, double[].class);
            }
        }
    }

    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    public void visit(RasterSymbolizer rs) {
        if (this.symbolizerGeometriesVisitEnabled && rs.getGeometry() != null) {
            rs.getGeometry().accept((ExpressionVisitor)this, Geometry.class);
        }
        if (rs.getImageOutline() != null) {
            rs.getImageOutline().accept((StyleVisitor)this);
        }
        if (rs.getOpacity() != null) {
            rs.getOpacity().accept((ExpressionVisitor)this, Double.class);
        }
    }

    public void visit(PointSymbolizer ps) {
        if (this.symbolizerGeometriesVisitEnabled) {
            if (ps.getGeometry() != null) {
                ps.getGeometry().accept((ExpressionVisitor)this, Geometry.class);
            } else {
                this.defaultGeometryUsed = true;
            }
        }
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    public void visit(LineSymbolizer line) {
        if (this.symbolizerGeometriesVisitEnabled) {
            if (line.getGeometry() != null) {
                line.getGeometry().accept((ExpressionVisitor)this, Geometry.class);
            } else {
                this.defaultGeometryUsed = true;
            }
        }
        if (line.getPerpendicularOffset() != null) {
            line.getPerpendicularOffset().accept((ExpressionVisitor)this, Double.class);
        }
        if (line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (this.symbolizerGeometriesVisitEnabled) {
            if (poly.getGeometry() != null) {
                poly.getGeometry().accept((ExpressionVisitor)this, Geometry.class);
            } else {
                this.defaultGeometryUsed = true;
            }
        }
        if (poly.getStroke() != null) {
            poly.getStroke().accept((StyleVisitor)this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept((StyleVisitor)this);
        }
    }

    public void visit(TextSymbolizer text) {
        if (this.symbolizerGeometriesVisitEnabled) {
            if (text.getGeometry() != null) {
                text.getGeometry().accept((ExpressionVisitor)this, null);
            } else {
                this.defaultGeometryUsed = true;
            }
        }
        if (text.getGraphic() != null) {
            text.getGraphic().accept((StyleVisitor)this);
        }
        if (text.getFill() != null) {
            text.getFill().accept((StyleVisitor)this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
        if (text.fonts() != null) {
            for (Font font : text.fonts()) {
                if (font.getFamily() != null) {
                    for (Expression list : font.getFamily()) {
                        list.accept((ExpressionVisitor)this, null);
                    }
                }
                if (font.getSize() != null) {
                    font.getSize().accept((ExpressionVisitor)this, Double.class);
                }
                if (font.getStyle() != null) {
                    font.getStyle().accept((ExpressionVisitor)this, String.class);
                }
                if (font.getWeight() == null) continue;
                font.getWeight().accept((ExpressionVisitor)this, String.class);
            }
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
        if (text.getLabel() != null) {
            text.getLabel().accept((ExpressionVisitor)this, null);
        }
        if (text.getLabelPlacement() != null) {
            text.getLabelPlacement().accept((StyleVisitor)this);
        }
        if (text.getPriority() != null) {
            text.getPriority().accept((ExpressionVisitor)this, Double.class);
        }
    }

    public void visit(Graphic gr) {
        for (GraphicalSymbol symbol : gr.graphicalSymbols()) {
            if (symbol instanceof Symbol) {
                ((Symbol)symbol).accept((StyleVisitor)this);
                continue;
            }
            throw new RuntimeException("Don't know how to visit " + symbol);
        }
        if (gr.getOpacity() != null) {
            gr.getOpacity().accept((ExpressionVisitor)this, Double.class);
        }
        if (gr.getRotation() != null) {
            gr.getRotation().accept((ExpressionVisitor)this, Double.class);
        }
        if (gr.getSize() != null) {
            gr.getSize().accept((ExpressionVisitor)this, Double.class);
        }
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept((StyleVisitor)this);
        }
        if (gr.getAnchorPoint() != null) {
            gr.getAnchorPoint().accept((StyleVisitor)this);
        }
    }

    public void visit(Mark mark) {
        if (mark.getFill() != null) {
            mark.getFill().accept((StyleVisitor)this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept((StyleVisitor)this);
        }
        if (mark.getWellKnownName() != null) {
            if (mark.getWellKnownName() instanceof Literal) {
                this.visitCqlExpression((String)mark.getWellKnownName().evaluate(null, String.class));
            } else {
                mark.getWellKnownName().accept((ExpressionVisitor)this, String.class);
            }
        }
    }

    private void visitCqlExpression(String expression) {
        Expression parsed = ExpressionExtractor.extractCqlExpressions((String)expression);
        if (parsed != null) {
            parsed.accept((ExpressionVisitor)this, null);
        }
    }

    public void visit(ExternalGraphic exgr) {
        this.visitCqlExpression(exgr.getFormat());
        try {
            if (exgr.getLocation() != null) {
                this.visitCqlExpression(exgr.getLocation().toString());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Errors while inspecting the location of an external graphic", e);
        }
    }

    public void visit(PointPlacement pp) {
        if (pp.getAnchorPoint() != null) {
            pp.getAnchorPoint().accept((StyleVisitor)this);
        }
        if (pp.getDisplacement() != null) {
            pp.getDisplacement().accept((StyleVisitor)this);
        }
        if (pp.getRotation() != null) {
            pp.getRotation().accept((ExpressionVisitor)this, Double.class);
        }
    }

    public void visit(AnchorPoint ap) {
        if (ap.getAnchorPointX() != null) {
            ap.getAnchorPointX().accept((ExpressionVisitor)this, Double.class);
        }
        if (ap.getAnchorPointY() != null) {
            ap.getAnchorPointY().accept((ExpressionVisitor)this, Double.class);
        }
    }

    public void visit(Displacement dis) {
        if (dis.getDisplacementX() != null) {
            dis.getDisplacementX().accept((ExpressionVisitor)this, Double.class);
        }
        if (dis.getDisplacementY() != null) {
            dis.getDisplacementY().accept((ExpressionVisitor)this, Double.class);
        }
    }

    public void visit(LinePlacement lp) {
        if (lp.getPerpendicularOffset() != null) {
            lp.getPerpendicularOffset().accept((ExpressionVisitor)this, Double.class);
        }
    }

    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept((StyleVisitor)this);
        }
        if (halo.getRadius() != null) {
            halo.getRadius().accept((ExpressionVisitor)this, Double.class);
        }
    }

    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers;
        for (StyledLayer layer : layers = sld.getStyledLayers()) {
            if (layer instanceof NamedLayer) {
                ((NamedLayer)layer).accept((StyleVisitor)this);
                continue;
            }
            if (!(layer instanceof UserLayer)) continue;
            ((UserLayer)layer).accept((StyleVisitor)this);
        }
    }

    public void visit(NamedLayer layer) {
        for (Style style : layer.getStyles()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(UserLayer layer) {
        for (Style style : layer.getUserStyles()) {
            style.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeConstraint ftc) {
        ftc.accept((StyleVisitor)this);
    }

    public void visit(ColorMap map) {
        for (ColorMapEntry entry : map.getColorMapEntries()) {
            entry.accept((StyleVisitor)this);
        }
    }

    public void visit(ColorMapEntry entry) {
        entry.accept((StyleVisitor)this);
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
        contrastEnhancement.accept((StyleVisitor)this);
    }

    public void visit(ImageOutline outline) {
        outline.getSymbolizer().accept((StyleVisitor)this);
    }

    public void visit(ChannelSelection cs) {
        cs.accept((StyleVisitor)this);
    }

    public void visit(OverlapBehavior ob) {
        ob.accept((StyleVisitor)this);
    }

    public void visit(SelectedChannelType sct) {
        sct.accept((StyleVisitor)this);
    }

    public void visit(ShadedRelief sr) {
        sr.accept((StyleVisitor)this);
    }

    public Object visit(PropertyName expression, Object data) {
        AttributeDescriptor ad = (AttributeDescriptor)expression.evaluate((Object)this.featureType);
        if (ad != null) {
            this.propertyTypes.put(expression, ad.getType().getBinding());
        } else if (data instanceof Class) {
            this.propertyTypes.put(expression, (Class)data);
        } else {
            this.propertyTypes.put(expression, Object.class);
        }
        return super.visit(expression, data);
    }

    public Map<PropertyName, Class<?>> getPropertyTypes() {
        return Collections.unmodifiableMap(this.propertyTypes);
    }
}

