/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.DocumentCallback;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.StyleDocument;
import org.geoserver.ogcapi.v1.styles.StyleMetadataDocument;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.util.Version;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class StyleDocumentCallback
implements DocumentCallback {
    Catalog catalog;

    public StyleDocumentCallback(Catalog catalog) {
        this.catalog = catalog;
    }

    public void apply(Request dr, AbstractDocument document) {
        if (document instanceof AbstractCollectionDocument) {
            AbstractCollectionDocument collection = (AbstractCollectionDocument)document;
            Object subject = collection.getSubject();
            if (subject instanceof ResourceInfo) {
                this.addResourceStyles(collection);
            } else if (!collection.getStyles().isEmpty()) {
                this.addLinks(collection.getStyles());
            }
        } else if (document instanceof StyleDocument) {
            StyleDocumentCallback.addStyleLinks((StyleDocument)document);
        }
    }

    private void addResourceStyles(AbstractCollectionDocument<?> collection) {
        ResourceInfo ri = (ResourceInfo)collection.getSubject();
        for (LayerInfo layer : this.catalog.getLayers(ri)) {
            LinkedHashSet<StyleInfo> styles = new LinkedHashSet<StyleInfo>();
            styles.add(layer.getDefaultStyle());
            styles.addAll(layer.getStyles());
            for (StyleInfo style : styles) {
                StyleDocument styleDocument = new StyleDocument(style);
                StyleDocumentCallback.addStyleLinks(styleDocument);
                collection.getStyles().add(styleDocument);
            }
        }
    }

    private void addLinks(List<StyleDocument> styleDocuments) {
        for (StyleDocument styleDocument : styleDocuments) {
            if (styleDocument.getStyle() == null) continue;
            StyleDocumentCallback.addStyleLinks(styleDocument);
        }
    }

    static void addStyleLinks(StyleDocument styleDocument) {
        APIRequestInfo info = APIRequestInfo.get();
        StyleInfo style = styleDocument.getStyle();
        String styleIdPathElement = ResponseUtils.urlEncode((String)styleDocument.getId(), (char[])new char[0]);
        for (StyleHandler sh : Styles.handlers()) {
            for (Version ver : sh.getVersions()) {
                if ((style.getFormat() == null || !sh.getFormat().equals(style.getFormat()) || !ver.equals((Object)style.getFormatVersion()) && style.getFormatVersion() != null) && !sh.supportsEncoding(ver)) continue;
                String styleURL = ResponseUtils.buildURL((String)info.getBaseURL(), (String)("ogc/styles/v1/styles/" + styleIdPathElement), Collections.singletonMap("f", sh.mimeType(ver)), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                Link link = new Link(styleURL, "stylesheet", sh.mimeType(ver), null);
                styleDocument.addLink(link);
            }
        }
        Collection metadataFormats = APIRequestInfo.get().getProducibleMediaTypes(StyleMetadataDocument.class, true);
        for (MediaType format : metadataFormats) {
            String metadataURL = ResponseUtils.buildURL((String)info.getBaseURL(), (String)("ogc/styles/v1/styles/" + styleIdPathElement + "/metadata"), Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            Link link = new Link(metadataURL, "describedBy", format.toString(), "The style metadata");
            styleDocument.addLink(link);
        }
    }
}

