/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.v1.styles.SampleDataSupport;
import org.geoserver.ogcapi.v1.styles.StyleDates;
import org.geoserver.ogcapi.v1.styles.StyleLayer;
import org.geoserver.ogcapi.v1.styles.StyleMetadataInfo;
import org.geoserver.ogcapi.v1.styles.Stylesheet;
import org.geoserver.ogcapi.v1.styles.ThumbnailBuilder;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.api.style.Description;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.util.Version;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StyleMetadataDocument
extends AbstractDocument {
    String id;
    String title;
    boolean titleSet;
    String description;
    boolean descriptionSet;
    List<String> keywords;
    boolean keywordsSet;
    String pointOfContact;
    boolean pointOfContactSet;
    String accessConstraints;
    boolean accessConstraintsSet;
    StyleDates dates;
    boolean datesSet;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    String scope = "style";
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    List<Stylesheet> stylesheets = new ArrayList<Stylesheet>();
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    List<StyleLayer> layers = new ArrayList<StyleLayer>();
    SampleDataSupport sampleDataSupport;

    public StyleMetadataDocument() {
    }

    public StyleMetadataDocument(StyleInfo si, GeoServer gs, SampleDataSupport sampleDataSupport, ThumbnailBuilder thumbnails) throws IOException {
        this.sampleDataSupport = sampleDataSupport;
        this.id = si.prefixedName();
        StyledLayerDescriptor sld = si.getSLD();
        Optional<StyleMetadataInfo> styleMetadata = Optional.ofNullable((StyleMetadataInfo)si.getMetadata().get(StyleMetadataInfo.METADATA_KEY, StyleMetadataInfo.class));
        this.title = styleMetadata.map(StyleMetadataInfo::getTitle).orElseGet(() -> this.getTitle(sld));
        this.description = styleMetadata.map(StyleMetadataInfo::getAbstract).orElseGet(() -> this.getDescription(sld));
        this.keywords = styleMetadata.map(StyleMetadataInfo::getKeywords).orElse(null);
        this.pointOfContact = styleMetadata.map(StyleMetadataInfo::getPointOfContact).orElseGet(() -> gs.getSettings().getContact().getContactPerson());
        this.accessConstraints = styleMetadata.map(StyleMetadataInfo::getAccessConstraints).orElse("unclassified");
        for (StyleHandler handler : Styles.handlers()) {
            for (Version version : handler.getVersions()) {
                Stylesheet ss = new Stylesheet(si, handler, version);
                if (!ss.isNative() && !handler.supportsEncoding(version)) continue;
                this.stylesheets.add(ss);
            }
        }
        StyledLayer[] styledLayers = sld.getStyledLayers();
        if (styledLayers.length == 1) {
            StyleLayer sl2 = new StyleLayer(si, styledLayers[0], gs.getCatalog(), sampleDataSupport, false);
            this.layers.add(sl2);
        } else {
            this.layers = Arrays.stream(styledLayers).filter(sl -> sl instanceof NamedLayer).map(nl -> new StyleLayer(si, (StyledLayer)nl, gs.getCatalog(), sampleDataSupport, true)).collect(Collectors.toList());
        }
        if (thumbnails.canGenerateThumbnail(si)) {
            String baseURL = APIRequestInfo.get().getBaseURL();
            String href = ResponseUtils.buildURL((String)baseURL, (String)("ogc/styles/v1/styles/" + ResponseUtils.urlEncode((String)si.prefixedName(), (char[])new char[0]) + "/thumbnail"), Collections.singletonMap("f", "image/png"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            this.addLink(new Link(href, "preview", "image/png", "Thumbnail for " + si.prefixedName()));
        }
    }

    private String getTitle(StyledLayerDescriptor sld) {
        if (sld.getTitle() != null) {
            return sld.getTitle();
        }
        return this.getDescriptions(sld).filter(d -> d.getTitle() != null).map(d -> d.getTitle().toString()).findFirst().orElse(null);
    }

    private String getDescription(StyledLayerDescriptor sld) {
        if (sld.getAbstract() != null) {
            return sld.getAbstract();
        }
        return this.getDescriptions(sld).filter(d -> d.getAbstract() != null).map(d -> d.getAbstract().toString()).findFirst().orElse(null);
    }

    private Stream<Description> getDescriptions(StyledLayerDescriptor sld) {
        return Arrays.stream(sld.getStyledLayers()).flatMap(sl -> {
            if (sl instanceof NamedLayer) {
                return Arrays.stream(((NamedLayer)sl).getStyles());
            }
            if (sl instanceof UserLayer) {
                return Arrays.stream(((UserLayer)sl).getUserStyles());
            }
            return Stream.empty();
        }).filter(s -> s != null && s.getDescription() != null && s.getDescription() != null).map(s -> s.getDescription());
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String getPointOfContact() {
        return this.pointOfContact;
    }

    public String getAccessConstraints() {
        return this.accessConstraints;
    }

    public StyleDates getDates() {
        return this.dates;
    }

    public String getScope() {
        return this.scope;
    }

    public List<Stylesheet> getStylesheets() {
        return this.stylesheets;
    }

    public List<StyleLayer> getLayers() {
        return this.layers;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.titleSet = true;
        this.title = title;
    }

    public void setDescription(String description) {
        this.descriptionSet = true;
        this.description = description;
    }

    public void setKeywords(List<String> keywords) {
        this.keywordsSet = true;
        this.keywords = keywords;
    }

    public void setPointOfContact(String pointOfContact) {
        this.pointOfContactSet = true;
        this.pointOfContact = pointOfContact;
    }

    public void setAccessConstraints(String accessConstraints) {
        this.accessConstraintsSet = true;
        this.accessConstraints = accessConstraints;
    }

    public void setDates(StyleDates dates) {
        this.dates = dates;
    }

    @JsonIgnore
    public boolean isTitleSet() {
        return this.titleSet;
    }

    @JsonIgnore
    public boolean isDescriptionSet() {
        return this.descriptionSet;
    }

    @JsonIgnore
    public boolean isKeywordsSet() {
        return this.keywordsSet;
    }

    @JsonIgnore
    public boolean isPointOfContactSet() {
        return this.pointOfContactSet;
    }

    @JsonIgnore
    public boolean isAccessConstraintsSet() {
        return this.accessConstraintsSet;
    }

    @JsonIgnore
    public boolean isDatesSet() {
        return this.datesSet;
    }
}

