/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.v1.styles.StyleMetadataInfo;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapDefaults;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class ThumbnailBuilder {
    static final Logger LOGGER = Logging.getLogger(ThumbnailBuilder.class);
    public static final int DEFAULT_PIXEL_SIZE = 512;
    DefaultWebMapService wms;
    private Catalog catalog;

    public ThumbnailBuilder(DefaultWebMapService wms, Catalog catalog) {
        this.wms = wms;
        this.catalog = catalog;
    }

    public RenderedImage buildThumbnailFor(StyleInfo styleInfo) throws IOException {
        GetMapRequest request = new GetMapRequest();
        this.setupLayersAndStyles(styleInfo, request);
        this.setupBoundsAndSizeFromConfiguration(styleInfo, request);
        GetMapDefaults defaulter = new GetMapDefaults();
        defaulter.setMaxSide(512);
        defaulter.autoSetMissingProperties(request);
        WebMap map = this.wms.getMap(request);
        if (map instanceof RenderedImageMap) {
            RenderedImageMap rim = (RenderedImageMap)map;
            return rim.getImage();
        }
        return null;
    }

    private void setupBoundsAndSizeFromConfiguration(StyleInfo styleInfo, GetMapRequest request) {
        StyleMetadataInfo metadata;
        ReferencedEnvelope envelope;
        Optional<StyleMetadataInfo> styleMetadata = Optional.ofNullable((StyleMetadataInfo)styleInfo.getMetadata().get(StyleMetadataInfo.METADATA_KEY, StyleMetadataInfo.class));
        if (styleMetadata.isPresent() && (envelope = (metadata = styleMetadata.get()).getThumbnailEnvelope()) != null) {
            request.setBbox((Envelope)envelope);
            request.setCrs(envelope.getCoordinateReferenceSystem());
            int thumbnailWidth = metadata.getThumbnailWidth();
            if (thumbnailWidth > 0) {
                request.setWidth(thumbnailWidth);
            }
        }
    }

    public void setupLayersAndStyles(StyleInfo styleInfo, GetMapRequest request) throws IOException {
        StyledLayerDescriptor sld = styleInfo.getSLD();
        if (sld.getStyledLayers().length == 1) {
            LayerInfo layer = this.getAssociatedLayer(styleInfo);
            if (layer == null) {
                throw new APIException("NoApplicableCode", "Could not find a suitable sample layer to build the thumbnail image, please associate a layer to the style", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            request.setLayers(Arrays.asList(new MapLayerInfo(layer)));
            request.setStyles(Arrays.asList(styleInfo.getStyle()));
        } else {
            try {
                LayerGroupInfo group = this.catalog.getFactory().createLayerGroup();
                group.getLayers().add(null);
                group.getStyles().add(styleInfo);
                request.setLayers(group.layers().stream().map(l -> new MapLayerInfo(l)).collect(Collectors.toList()));
                request.setStyles(group.styles().stream().map(s -> {
                    try {
                        return s.getStyle();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList()));
            }
            catch (Exception e) {
                throw new APIException("InternalError", "Error happened while setting up thumbnail calculation for a style group", HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
    }

    private LayerInfo getAssociatedLayer(StyleInfo styleInfo) {
        LayerInfo layer = null;
        try (CloseableIterator layers = this.catalog.list(LayerInfo.class, Predicates.or((Filter)Predicates.equal((String)"defaultStyle", (Object)styleInfo), (Filter)Predicates.equal((String)"styles", (Object)styleInfo, (MultiValuedFilter.MatchAction)MultiValuedFilter.MatchAction.ANY)), null, null, Predicates.sortBy((String)"prefixedName", (boolean)true));){
            while (layers.hasNext()) {
                LayerInfo next = (LayerInfo)layers.next();
                if (styleInfo.equals(next.getDefaultStyle())) {
                    layer = next;
                    break;
                }
                if (layer != null) continue;
                layer = next;
            }
        }
        return layer;
    }

    public boolean canGenerateThumbnail(StyleInfo styleInfo) {
        GetMapRequest request = new GetMapRequest();
        try {
            this.setupLayersAndStyles(styleInfo, request);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Could not setup thumbnail", e);
        }
        return !request.getLayers().isEmpty();
    }
}

