/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.v1.styles.SampleDataSupport;
import org.geoserver.ogcapi.v1.styles.StyleAttribute;
import org.geoserver.ogcapi.v1.styles.StyleAttributeExtractor;
import org.geoserver.ogcapi.v1.styles.SymbolizerTypeVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StyleLayer {
    static final Logger LOGGER = Logging.getLogger(StyleLayer.class);
    String id;
    LayerType type;
    List<Link> sampleData = new ArrayList<Link>();
    List<StyleAttribute> attributes;
    SampleDataSupport sampleDataSupport;

    public StyleLayer(StyleInfo si, StyledLayer source, Catalog catalog, SampleDataSupport sampleDataSupport, boolean filterOnStyleLayerName) {
        this.sampleDataSupport = sampleDataSupport;
        this.id = Optional.ofNullable(source.getName()).orElse("layer");
        if (filterOnStyleLayerName) {
            LayerInfo layer = si.getWorkspace() == null ? catalog.getLayerByName(source.getName()) : (source.getName().contains(":") ? catalog.getLayerByName(source.getName()) : catalog.getLayerByName(si.getWorkspace().getName() + ":" + source.getName()));
            if (layer != null) {
                this.addLayerInfo(source, sampleDataSupport, layer);
            }
        } else {
            Filter layerFilter = Predicates.or((Filter)Predicates.equal((String)"defaultStyle", (Object)si), (Filter)Predicates.equal((String)"styles", (Object)si, (MultiValuedFilter.MatchAction)MultiValuedFilter.MatchAction.ANY));
            try (CloseableIterator layers = catalog.list(LayerInfo.class, layerFilter);){
                while (layers.hasNext()) {
                    LayerInfo layer = (LayerInfo)layers.next();
                    this.addLayerInfo(source, sampleDataSupport, layer);
                }
            }
        }
        if (this.type == null) {
            this.type = this.guessLayerType(source);
            this.attributes = this.getAttributes(source, null);
        }
    }

    public void addLayerInfo(StyledLayer source, SampleDataSupport sampleDataSupport, LayerInfo layer) {
        if (this.type == null) {
            try {
                ResourceInfo resource = layer.getResource();
                if (resource instanceof FeatureTypeInfo) {
                    FeatureType featureType = ((FeatureTypeInfo)resource).getFeatureType();
                    this.type = this.getLayerType(featureType);
                    this.attributes = this.getAttributes(source, featureType);
                } else if (resource instanceof CoverageInfo) {
                    this.type = LayerType.raster;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not grab type information from layer " + layer.prefixedName() + ", skipping and moving on");
            }
        }
        List<Link> sampleDataLinks = sampleDataSupport.getSampleDataFor(layer);
        this.sampleData.addAll(sampleDataLinks);
    }

    private LayerType guessLayerType(StyledLayer source) {
        SymbolizerTypeVisitor typeVisitor = new SymbolizerTypeVisitor();
        this.acceptvisitor(source, (StyleVisitor)typeVisitor);
        Set<Class<? extends Symbolizer>> types = typeVisitor.getSymbolizerTypes();
        if (this.containsSymbolizer(types, RasterSymbolizer.class)) {
            return LayerType.raster;
        }
        if (this.containsSymbolizer(types, PolygonSymbolizer.class)) {
            return LayerType.polygon;
        }
        if (this.containsSymbolizer(types, LineSymbolizer.class)) {
            return LayerType.line;
        }
        if (this.containsSymbolizer(types, PointSymbolizer.class)) {
            return LayerType.point;
        }
        return LayerType.geometry;
    }

    private boolean containsSymbolizer(Set<Class<? extends Symbolizer>> types, Class<? extends Symbolizer> target) {
        return types.stream().anyMatch(symbolizerClass -> target.isAssignableFrom((Class<?>)symbolizerClass));
    }

    private LayerType getLayerType(FeatureType featureType) {
        GeometryDescriptor gd = featureType.getGeometryDescriptor();
        Class binding = gd.getType().getBinding();
        if (Point.class.isAssignableFrom(binding) || MultiPoint.class.isAssignableFrom(binding)) {
            return LayerType.point;
        }
        if (LineString.class.isAssignableFrom(binding) || MultiLineString.class.isAssignableFrom(binding)) {
            return LayerType.line;
        }
        if (Polygon.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding)) {
            return LayerType.polygon;
        }
        return LayerType.geometry;
    }

    public void acceptvisitor(StyledLayer source, StyleVisitor visitor) {
        if (source instanceof NamedLayer) {
            ((NamedLayer)source).accept(visitor);
        } else {
            ((UserLayer)source).accept(visitor);
        }
    }

    private List<StyleAttribute> getAttributes(StyledLayer source, FeatureType featureType) {
        StyleAttributeExtractor extractor = featureType instanceof SimpleFeatureType ? new StyleAttributeExtractor((SimpleFeatureType)featureType) : new StyleAttributeExtractor();
        this.acceptvisitor(source, extractor);
        Map<PropertyName, Class<?>> propertyTypes = extractor.getPropertyTypes();
        return propertyTypes.entrySet().stream().map(e -> {
            StyleAttribute sa = new StyleAttribute();
            sa.setId(((PropertyName)e.getKey()).getPropertyName());
            sa.setType(this.getAttributeType((Class)e.getValue()));
            return sa;
        }).collect(Collectors.toList());
    }

    private StyleAttribute.AttributeType getAttributeType(Class<?> binding) {
        if (Number.class.isAssignableFrom(binding)) {
            if (Float.class.isAssignableFrom(binding) || Double.class.isAssignableFrom(binding) || BigDecimal.class.isAssignableFrom(binding)) {
                return StyleAttribute.AttributeType.number;
            }
            return StyleAttribute.AttributeType.integer;
        }
        if (Date.class.isAssignableFrom(binding)) {
            return StyleAttribute.AttributeType.date;
        }
        if (java.util.Date.class.isAssignableFrom(binding)) {
            return StyleAttribute.AttributeType.dateTime;
        }
        if (Boolean.class.isAssignableFrom(binding)) {
            return StyleAttribute.AttributeType.bool;
        }
        return StyleAttribute.AttributeType.string;
    }

    public String getId() {
        return this.id;
    }

    public LayerType getType() {
        return this.type;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Link> getSampleData() {
        return this.sampleData;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<StyleAttribute> getAttributes() {
        return this.attributes;
    }

    static enum LayerType {
        point,
        line,
        polygon,
        geometry,
        raster;

    }
}

