/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.OpenAPIBuilder;
import org.geoserver.ogcapi.v1.styles.StylesDocument;
import org.geoserver.ogcapi.v1.styles.StylesService;
import org.geoserver.ogcapi.v1.styles.StylesServiceInfo;

public class StylesAPIBuilder
extends OpenAPIBuilder<StylesServiceInfo> {
    public StylesAPIBuilder() {
        super(StylesAPIBuilder.class, "openapi.yaml", "Style API", StylesService.class);
    }

    public OpenAPI build(StylesServiceInfo service) throws IOException {
        OpenAPI api = super.build((ServiceInfo)service);
        this.declareGetResponseFormats(api, "/styles", StylesDocument.class);
        this.declareGetResponseFormats(api, "/styles/{styleId}", StylesDocument.class);
        api.getPaths().remove((Object)"/resources");
        Map parameters = api.getComponents().getParameters();
        Parameter styleId = (Parameter)parameters.get("styleId");
        Catalog catalog = service.getGeoServer().getCatalog();
        List validStyleIds = catalog.getStyles().stream().map(si -> si.prefixedName()).collect(Collectors.toList());
        styleId.getSchema().setEnum(validStyleIds);
        return api;
    }
}

