/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.servers.Server;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ogcapi.v1.styles.StylesTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ApiTest
extends StylesTestSupport {
    @Test
    public void testApiJson() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/styles/v1/openapi", 200);
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/vnd.oai.openapi+json;version=3.0"));
        String json = response.getContentAsString();
        LOGGER.log(Level.INFO, json);
        ObjectMapper mapper = Json.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(json, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testApiHTML() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/styles/v1/openapi?f=text/html", 200);
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String html = response.getContentAsString();
        LOGGER.info(html);
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-32x32.png\" sizes=\"32x32\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<link rel=\"icon\" type=\"image/png\" href=\"http://localhost:8080/geoserver/swagger-ui/favicon-16x16.png\" sizes=\"16x16\" />"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-bundle.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/swagger-ui/swagger-ui-standalone-preset.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/api.js\">"));
        MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"<input type=\"hidden\" id=\"apiLocation\" value=\"http://localhost:8080/geoserver/ogc/styles/v1/openapi?f=application%2Fvnd.oai.openapi%2Bjson%3Bversion%3D3.0\"/>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"<script>")));
    }

    @Test
    public void testApiYaml() throws Exception {
        String yaml = this.getAsString("ogc/styles/v1/openapi?f=application/yaml");
        LOGGER.log(Level.INFO, yaml);
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    @Test
    public void testYamlAsAcceptsHeader() throws Exception {
        MockHttpServletRequest request = this.createRequest("ogc/styles/v1/openapi");
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept", (Object)"foo/bar, application/yaml, text/html");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/yaml"));
        String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        ObjectMapper mapper = Yaml.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
        this.validateApi(api);
    }

    private void validateApi(OpenAPI api) {
        List servers = api.getServers();
        MatcherAssert.assertThat((Object)servers, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Server)servers.get(0)).getUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/styles/v1"));
        Paths paths = api.getPaths();
        PathItem landing = (PathItem)paths.get((Object)"/");
        Assert.assertNotNull((Object)landing);
        MatcherAssert.assertThat((Object)landing.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getLandingPage"));
        PathItem conformance = (PathItem)paths.get((Object)"/conformance");
        Assert.assertNotNull((Object)conformance);
        MatcherAssert.assertThat((Object)conformance.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getConformanceClasses"));
        PathItem collections = (PathItem)paths.get((Object)"/styles");
        Assert.assertNotNull((Object)collections);
        MatcherAssert.assertThat((Object)collections.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getStyleSet"));
        PathItem collection = (PathItem)paths.get((Object)"/styles/{styleId}");
        Assert.assertNotNull((Object)collection);
        MatcherAssert.assertThat((Object)collection.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getStyle"));
        Parameter styleId = (Parameter)api.getComponents().getParameters().get("styleId");
        MatcherAssert.assertThat((Object)styleId.getSchema().getEnum(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"BasicStyleGroupStyle", "cssSample", "PolygonComment", "ws:NamedPlacesWS", "generic", "polygon", "line", "point", "Streams", "RoadSegments", "Ponds", "NamedPlaces", "MapNeatline", "Lakes", "Forests", "DividedRoutes", "Buildings", "Bridges", "BasicPolygons", "raster", "Default"}));
    }

    @Test
    public void testWorkspaceQualifiedAPI() throws Exception {
        OpenAPI api = this.getOpenAPI("ws/ogc/styles/v1/openapi");
        Map params = api.getComponents().getParameters();
        Parameter styleId = (Parameter)params.get("styleId");
        List styleIdValues = styleId.getSchema().getEnum();
        List expectedStyleIds = this.getCatalog().getStyles().stream().filter(s -> s.getWorkspace() == null || "ws".equals(s.getWorkspace().getName())).map(StyleInfo::getName).collect(Collectors.toList());
        Collections.sort(styleIdValues);
        Collections.sort(expectedStyleIds);
        Assert.assertEquals((Object)styleIdValues, expectedStyleIds);
    }

    @Test
    public void testWorkspaceQualifiedAPIGlobalOnly() throws Exception {
        OpenAPI api = this.getOpenAPI("cdf/ogc/styles/v1/openapi");
        Map params = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)params.get("styleId");
        List collectionIdValues = collectionId.getSchema().getEnum();
        List expectedStyleIds = this.getCatalog().getStyles().stream().filter(s -> s.getWorkspace() == null).map(StyleInfo::getName).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)collectionIdValues, (Matcher)CoreMatchers.equalTo(expectedStyleIds));
    }

    private OpenAPI getOpenAPI(String path) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept", (Object)"foo/bar, application/yaml, text/html");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/yaml", (Object)response.getContentType());
        String yaml = this.string(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        ObjectMapper mapper = Yaml.mapper();
        return (OpenAPI)mapper.readValue(yaml, OpenAPI.class);
    }
}

