/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.jayway.jsonpath.DocumentContext;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.styles.StylesTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class CollectionCallbackIntegrationTest
extends StylesTestSupport {
    @Test
    public void testFeatureCollectionCallback() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + this.getLayerId(MockData.BASIC_POLYGONS), 200);
        Assert.assertEquals((Object)"A blue linestring style", (Object)this.readSingle(json, "styles[?(@.id == 'BasicPolygons')].title"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/BasicPolygons?f=application%2Fvnd.ogc.sld%2Bxml", (Object)this.readSingle(json, "styles[?(@.id == 'BasicPolygons')].links[?(@.rel == 'stylesheet' && @.type == 'application/vnd.ogc.sld+xml')].href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/BasicPolygons/metadata?f=application%2Fjson", (Object)this.readSingle(json, "styles[?(@.id == 'BasicPolygons')].links[?(@.rel == 'describedBy' && @.type == 'application/json')].href"));
    }

    @Test
    public void testTilesCollectionCallback() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + this.getLayerId(MockData.BASIC_POLYGONS), 200);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/BasicPolygons?f=application%2Fvnd.ogc.sld%2Bxml", (Object)this.readSingle(json, "styles[?(@.id == 'BasicPolygons')].links[?(@.rel == 'stylesheet' && @.type == 'application/vnd.ogc.sld+xml')].href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/BasicPolygons/metadata?f=application%2Fjson", (Object)this.readSingle(json, "styles[?(@.id == 'BasicPolygons')].links[?(@.rel == 'describedBy' && @.type == 'application/json')].href"));
    }

    @Test
    public void testTilesCollectionGroupCallback() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/BasicStyleGroup", 200);
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/BasicStyleGroupStyle?f=application%2Fvnd.ogc.sld%2Bxml", (Object)this.readSingle(json, "styles[?(@.id == 'BasicStyleGroupStyle')].links[?(@.rel == 'stylesheet' && @.type == 'application/vnd.ogc.sld+xml')].href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/styles/v1/styles/BasicStyleGroupStyle/metadata?f=application%2Fjson", (Object)this.readSingle(json, "styles[?(@.id == 'BasicStyleGroupStyle')].links[?(@.rel == 'describedBy' && @.type == 'application/json')].href"));
    }
}

