/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.v1.styles.StyleDates;
import org.geoserver.ogcapi.v1.styles.StyleMetadataInfo;
import org.geoserver.ogcapi.v1.styles.StyleTest;
import org.geoserver.ogcapi.v1.styles.StylesTestSupport;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.util.IOUtils;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.ApplicationMime;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.TextNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class StyleMetadataTest
extends StylesTestSupport {
    public static final String POLYGON_TITLE = "A polygon style";
    public static final String POLYGON_ABSTRACT = "Draws polygons with gray fill, black outline";
    public static final String POLYGON_CONTRAINTS = "restricted";
    public static final String POLYGON_POC = "Claudius";
    public static final QName BUILDINGS_LABEL = new QName(MockData.BUILDINGS.getNamespaceURI(), "BuildingsLabels", MockData.BUILDINGS.getPrefix());
    public static final String BUILDINGS_LABEL_ASSOCIATED_STYLE = "BuildingsLabelAssociated";
    public static final String BUILDINGS_LABEL_STYLE = "BuildingsLabel";
    public static final String TASMANIA = "tasmania";
    public static final String BUILDINGS_LAKES = "buildingsLakes";

    @Before
    public void clearMetadata() {
        StyleInfo polygon = this.getCatalog().getStyleByName("polygon");
        StyleMetadataInfo metadata = new StyleMetadataInfo();
        metadata.setTitle(POLYGON_TITLE);
        metadata.setAbstract(POLYGON_ABSTRACT);
        metadata.setAccessConstraints(POLYGON_CONTRAINTS);
        metadata.setKeywords(new ArrayList<String>(Arrays.asList("polygon", "test")));
        metadata.setPointOfContact(POLYGON_POC);
        polygon.getMetadata().put(StyleMetadataInfo.METADATA_KEY, (Serializable)metadata);
        this.getCatalog().save(polygon);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addStyle(BUILDINGS_LABEL_STYLE, "BuildingsLabel.sld", StyleMetadataTest.class, this.getCatalog());
        testData.addStyle(BUILDINGS_LABEL_ASSOCIATED_STYLE, "BuildingsLabel.sld", StyleMetadataTest.class, this.getCatalog());
        testData.addVectorLayer(BUILDINGS_LABEL, Map.ofEntries(Map.entry(SystemTestData.LayerProperty.STYLE, BUILDINGS_LABEL_ASSOCIATED_STYLE), Map.entry(SystemTestData.LayerProperty.NAME, BUILDINGS_LABEL.getLocalPart())), StyleMetadataTest.class, this.getCatalog());
        String buildingsLabelId = this.getLayerId(BUILDINGS_LABEL);
        GWC gwc = (GWC)GeoServerExtensions.bean(GWC.class);
        GeoServerTileLayer buildingTiles = (GeoServerTileLayer)gwc.getTileLayerByName(buildingsLabelId);
        Set formats = buildingTiles.getInfo().getMimeFormats();
        formats.add(ApplicationMime.mapboxVector.getFormat());
        formats.add(ApplicationMime.topojson.getFormat());
        formats.add(ApplicationMime.geojson.getFormat());
        gwc.save((TileLayer)buildingTiles);
        testData.addStyle(TASMANIA, "tasmania.sld", StyleMetadataTest.class, this.getCatalog());
        testData.addVectorLayer(MockData.LAKES, this.getCatalog());
        testData.addStyle(BUILDINGS_LAKES, "buildingsLakes.sld", StyleMetadataTest.class, this.getCatalog());
    }

    @Test
    public void testGetMetadataFromRasterStyle() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/raster/metadata", 200);
        TestCase.assertEquals((String)"raster", (String)((String)json.read("id", new Predicate[0])));
        TestCase.assertEquals((String)"Raster", (String)((String)json.read("title", new Predicate[0])));
        TestCase.assertEquals((String)"A sample style for rasters, good for displaying imagery", (String)((String)json.read("description", new Predicate[0])));
        TestCase.assertEquals((String)"Andrea Aime", (String)((String)json.read("pointOfContact", new Predicate[0])));
        TestCase.assertEquals((String)"style", (String)((String)json.read("scope", new Predicate[0])));
        TestCase.assertEquals((String)"unclassified", (String)((String)json.read("accessConstraints", new Predicate[0])));
        TestCase.assertEquals((Object)1, (Object)((Integer)json.read("layers.size()", new Predicate[0])));
        TestCase.assertEquals((String)"raster", (String)((String)json.read("layers[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"raster", (String)((String)json.read("layers[0].type", new Predicate[0])));
    }

    @Test
    public void testGetMetadataFromConfiguredMetadata() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/polygon/metadata", 200);
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("id", new Predicate[0])));
        TestCase.assertEquals((String)POLYGON_TITLE, (String)((String)json.read("title", new Predicate[0])));
        TestCase.assertEquals((String)POLYGON_ABSTRACT, (String)((String)json.read("description", new Predicate[0])));
        TestCase.assertEquals((String)POLYGON_POC, (String)((String)json.read("pointOfContact", new Predicate[0])));
        TestCase.assertEquals((String)"style", (String)((String)json.read("scope", new Predicate[0])));
        TestCase.assertEquals((String)POLYGON_CONTRAINTS, (String)((String)json.read("accessConstraints", new Predicate[0])));
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("keywords[0]", new Predicate[0])));
        TestCase.assertEquals((String)"test", (String)((String)json.read("keywords[1]", new Predicate[0])));
        TestCase.assertEquals((Object)1, (Object)((Integer)json.read("layers.size()", new Predicate[0])));
        TestCase.assertEquals((String)"Default Polygon", (String)((String)json.read("layers[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("layers[0].type", new Predicate[0])));
    }

    @Test
    public void testGetMetadataHTML() throws Exception {
        Document doc = this.getAsJSoup("ogc/styles/v1/styles/polygon/metadata?f=html");
        TestCase.assertEquals((String)"Title: A polygon style", (String)doc.select("#title").text());
        TestCase.assertEquals((String)"Description: Draws polygons with gray fill, black outline", (String)doc.select("#description").text());
        TestCase.assertEquals((String)"Point of contact: Claudius", (String)doc.select("#poc").text());
        TestCase.assertEquals((String)"Stylesheet as SLD 1.0.0 (native)", (String)doc.select("#stylesheets>ul>:eq(0)").text());
        TestCase.assertEquals((String)"Default Polygon: polygon.", (String)((TextNode)doc.select("#layers>ul>li").first().textNodes().get(0)).text().trim());
    }

    @Test
    public void testGetMetadataHTMLRemovedInlineJS() throws Exception {
        String html = this.getAsString("ogc/styles/v1/styles/polygon/metadata?f=html");
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/common.js\"></script>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"form-select-open-basic"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"onchange")));
    }

    @Test
    public void testGetMetadataAttributesFromStyle() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/BuildingsLabel/metadata", 200);
        TestCase.assertEquals((String)BUILDINGS_LABEL_STYLE, (String)((String)json.read("id", new Predicate[0])));
        TestCase.assertEquals((Object)1, (Object)((Integer)json.read("layers.size()", new Predicate[0])));
        TestCase.assertEquals((String)"Buildings", (String)((String)json.read("layers[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("layers[0].type", new Predicate[0])));
        TestCase.assertEquals((String)"FID", (String)((String)json.read("layers[0].attributes[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"string", (String)((String)json.read("layers[0].attributes[0].type", new Predicate[0])));
        TestCase.assertEquals((String)"ADDRESS", (String)((String)json.read("layers[0].attributes[1].id", new Predicate[0])));
        TestCase.assertEquals((String)"string", (String)((String)json.read("layers[0].attributes[1].type", new Predicate[0])));
    }

    @Test
    public void testGetMetadataAttributesFromAssociatedStyle() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/BuildingsLabelAssociated/metadata", 200);
        TestCase.assertEquals((String)BUILDINGS_LABEL_ASSOCIATED_STYLE, (String)((String)json.read("id", new Predicate[0])));
        TestCase.assertEquals((Object)1, (Object)((Integer)json.read("layers.size()", new Predicate[0])));
        TestCase.assertEquals((String)"Buildings", (String)((String)json.read("layers[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("layers[0].type", new Predicate[0])));
        TestCase.assertEquals((String)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ABuildingsLabels/items?f=application%2Fgeo%2Bjson&limit=50", (String)((String)this.readSingle(json, "layers[?(@.id == 'Buildings')].sampleData[?(@.rel == 'data' && @.type == 'application/geo+json')].href")));
        TestCase.assertEquals((String)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite%3ABuildingsLabels%2Ftiles?f=application%2Fvnd.mapbox-vector-tile", (String)((String)this.readSingle(json, "layers[?(@.id == 'Buildings')].sampleData[?(@.rel == 'tiles' && @.type == 'application/vnd.mapbox-vector-tile')].href")));
        TestCase.assertEquals((String)"FID", (String)((String)json.read("layers[0].attributes[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"integer", (String)((String)json.read("layers[0].attributes[0].type", new Predicate[0])));
        TestCase.assertEquals((String)"ADDRESS", (String)((String)json.read("layers[0].attributes[1].id", new Predicate[0])));
        TestCase.assertEquals((String)"string", (String)((String)json.read("layers[0].attributes[1].type", new Predicate[0])));
        TestCase.assertEquals((String)"DATE", (String)((String)json.read("layers[0].attributes[2].id", new Predicate[0])));
        TestCase.assertEquals((String)"dateTime", (String)((String)json.read("layers[0].attributes[2].type", new Predicate[0])));
        TestCase.assertEquals((String)"YESNO", (String)((String)json.read("layers[0].attributes[3].id", new Predicate[0])));
        TestCase.assertEquals((String)"boolean", (String)((String)json.read("layers[0].attributes[3].type", new Predicate[0])));
    }

    @Test
    public void testGetMetadataMultilayer() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/tasmania/metadata", 200);
        TestCase.assertEquals((String)TASMANIA, (String)((String)json.read("id", new Predicate[0])));
        TestCase.assertEquals((Object)4, (Object)((Integer)json.read("layers.size()", new Predicate[0])));
        TestCase.assertEquals((String)"WaterBodies", (String)((String)json.read("layers[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("layers[0].type", new Predicate[0])));
        TestCase.assertEquals((String)"PERIMETER", (String)((String)json.read("layers[0].attributes[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"string", (String)((String)json.read("layers[0].attributes[0].type", new Predicate[0])));
        TestCase.assertEquals((String)"AREA", (String)((String)json.read("layers[0].attributes[1].id", new Predicate[0])));
        TestCase.assertEquals((String)"string", (String)((String)json.read("layers[0].attributes[1].type", new Predicate[0])));
        TestCase.assertEquals((String)"name", (String)((String)json.read("layers[0].attributes[2].id", new Predicate[0])));
        TestCase.assertEquals((String)"string", (String)((String)json.read("layers[0].attributes[2].type", new Predicate[0])));
        TestCase.assertEquals((String)"WATER_TYPE", (String)((String)json.read("layers[0].attributes[3].id", new Predicate[0])));
        TestCase.assertEquals((String)"string", (String)((String)json.read("layers[0].attributes[3].type", new Predicate[0])));
        TestCase.assertEquals((String)"Roads", (String)((String)json.read("layers[1].id", new Predicate[0])));
        TestCase.assertEquals((String)"line", (String)((String)json.read("layers[1].type", new Predicate[0])));
        TestCase.assertEquals((String)"Cities", (String)((String)json.read("layers[2].id", new Predicate[0])));
        TestCase.assertEquals((String)"point", (String)((String)json.read("layers[2].type", new Predicate[0])));
        TestCase.assertEquals((String)"Land", (String)((String)json.read("layers[3].id", new Predicate[0])));
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("layers[3].type", new Predicate[0])));
    }

    @Test
    public void testGetMetadataMultilayerSampleData() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/buildingsLakes/metadata", 200);
        TestCase.assertEquals((String)BUILDINGS_LAKES, (String)((String)json.read("id", new Predicate[0])));
        TestCase.assertEquals((Object)2, (Object)((Integer)json.read("layers.size()", new Predicate[0])));
        TestCase.assertEquals((String)"Lakes", (String)((String)json.read("layers[0].id", new Predicate[0])));
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("layers[0].type", new Predicate[0])));
        TestCase.assertEquals((String)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ALakes/items?f=application%2Fgeo%2Bjson&limit=50", (String)((String)this.readSingle(json, "layers[0].sampleData[?(@.type=='application/geo+json')].href")));
        TestCase.assertEquals((String)"Buildings", (String)((String)json.read("layers[1].id", new Predicate[0])));
        TestCase.assertEquals((String)"polygon", (String)((String)json.read("layers[1].type", new Predicate[0])));
        TestCase.assertEquals((String)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite%3ABuildings/items?f=application%2Fgeo%2Bjson&limit=50", (String)((String)this.readSingle(json, "layers[1].sampleData[?(@.type=='application/geo+json')].href")));
    }

    @Test
    public void testGetMetadataFromCSSStyle() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/styles/v1/styles/cssSample/metadata", 200);
        TestCase.assertEquals((String)"cssSample", (String)((String)json.read("id", new Predicate[0])));
        TestCase.assertEquals((String)"A CSS style", (String)((String)json.read("title", new Predicate[0])));
        TestCase.assertEquals((String)"A simple polygon fill in CSS", (String)((String)json.read("description", new Predicate[0])));
        TestCase.assertEquals((String)"Andrea Aime", (String)((String)json.read("pointOfContact", new Predicate[0])));
        TestCase.assertEquals((String)"style", (String)((String)json.read("scope", new Predicate[0])));
        TestCase.assertEquals((String)"unclassified", (String)((String)json.read("accessConstraints", new Predicate[0])));
        MatcherAssert.assertThat((Object)((Integer)json.read("stylesheets.size()", Integer.class, new Predicate[0])), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
        TestCase.assertFalse((boolean)((Boolean)this.readSingle(json, "stylesheets[?(@.title =~ /.*SLD 1.0.*/)].native")));
        TestCase.assertTrue((boolean)((Boolean)this.readSingle(json, "stylesheets[?(@.title =~ /.*CSS.*/)].native")));
        TestCase.assertEquals((String)"Stylesheet as CSS 1.0.0", (String)((String)this.readSingle(json, "stylesheets[?(@.title =~ /.*CSS.*/)].title")));
        TestCase.assertEquals((String)"1.0.0", (String)((String)this.readSingle(json, "stylesheets[?(@.title =~ /.*CSS.*/)].version")));
        TestCase.assertEquals((String)"https://docs.geoserver.org/latest/en/user/styling/css/index.html", (String)((String)this.readSingle(json, "stylesheets[?(@.title =~ /.*CSS.*/)].specification")));
        TestCase.assertEquals((String)"http://localhost:8080/geoserver/ogc/styles/v1/styles/cssSample?f=application%2Fvnd.geoserver.geocss%2Bcss", (String)((String)this.readSingle(json, "stylesheets[?(@.title =~ /.*CSS.*/)].link.href")));
        TestCase.assertEquals((String)"application/vnd.geoserver.geocss+css", (String)((String)this.readSingle(json, "stylesheets[?(@.title =~ /.*CSS.*/)].link.type")));
    }

    @Test
    public void testPutStyleMetadata() throws Exception {
        String metadataJson = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("polygonStyleMetadata.json"));
        MockHttpServletResponse response = this.putAsServletResponse("ogc/styles/v1/styles/polygon/metadata", metadataJson, "application/json");
        TestCase.assertEquals((int)204, (int)response.getStatus());
        StyleInfo polygon = this.getCatalog().getStyleByName("polygon");
        StyleMetadataInfo metadata = (StyleMetadataInfo)polygon.getMetadata().get(StyleMetadataInfo.METADATA_KEY, StyleMetadataInfo.class);
        TestCase.assertEquals((String)"A polygon style with a twist", (String)metadata.getTitle());
        TestCase.assertEquals((String)"Draws polygons with gray fill. Gray is the new black!", (String)metadata.getAbstract());
        TestCase.assertEquals(Arrays.asList("polygon", "test", "hip"), (Object)metadata.getKeywords());
        StyleDates dates = metadata.getDates();
        TestCase.assertEquals((Object)this.parseDate("2019-01-01T10:05:00Z"), (Object)dates.getCreation());
        TestCase.assertEquals((Object)this.parseDate("2019-01-01T11:05:00Z"), (Object)dates.getPublication());
        TestCase.assertEquals((Object)this.parseDate("2019-02-01T11:05:00Z"), (Object)dates.getRevision());
        TestCase.assertEquals((Object)this.parseDate("2019-05-01T11:05:00Z"), (Object)dates.getValidTill());
        TestCase.assertEquals((Object)this.parseDate("2019-02-01T11:05:00Z"), (Object)dates.getReceivedOn());
    }

    public Date parseDate(String date) {
        return DatatypeConverter.parseDate((String)date).getTime();
    }

    @Test
    public void testPatchStyleMetadata() throws Exception {
        this.testPutStyleMetadata();
        String jsonPatch = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("metadataPatch.json"));
        MockHttpServletResponse response = this.patchAsServletResponse("ogc/styles/v1/styles/polygon/metadata", jsonPatch, "application/json");
        TestCase.assertEquals((int)204, (int)response.getStatus());
        StyleInfo polygon = this.getCatalog().getStyleByName("polygon");
        StyleMetadataInfo metadata = (StyleMetadataInfo)polygon.getMetadata().get(StyleMetadataInfo.METADATA_KEY, StyleMetadataInfo.class);
        TestCase.assertEquals((String)"A polygon style with a twist", (String)metadata.getTitle());
        Assert.assertNull((Object)metadata.getAbstract());
        TestCase.assertEquals((String)"Jane Doe", (String)metadata.getPointOfContact());
        TestCase.assertEquals(Arrays.asList("polygon", "test", "hip"), (Object)metadata.getKeywords());
        StyleDates dates = metadata.getDates();
        TestCase.assertEquals((Object)this.parseDate("2019-05-17T11:46:12Z"), (Object)dates.getRevision());
        Assert.assertNull((Object)dates.getValidTill());
    }

    @Test
    public void testRoundTrip() throws Exception {
        String metadatPath = "ogc/styles/v1/styles/raster/metadata";
        String payload = this.getAsString(metadatPath);
        MockHttpServletResponse response = this.putAsServletResponse(metadatPath, payload, "application/json");
        TestCase.assertEquals((String)response.getContentAsString(), (int)204, (int)response.getStatus());
        this.testGetMetadataFromRasterStyle();
    }
}

