/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import junit.framework.TestCase;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.v1.styles.StylesTestSupport;
import org.geoserver.util.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class StyleTest
extends StylesTestSupport {
    public static final String MY_NEW_STYLE = "myNewStyle";
    public static final String SIMPLE_POINT = "SimplePoint";

    @Before
    public void addPondsStyle() throws IOException {
        ((SystemTestData)this.getTestData()).addStyle(SystemTestData.PONDS.getLocalPart(), this.getCatalog());
        this.cleanupStyle(MY_NEW_STYLE);
        this.cleanupStyle(SIMPLE_POINT);
    }

    public void cleanupStyle(String styleName) {
        StyleInfo myNewStyle = this.getCatalog().getStyleByName(styleName);
        if (myNewStyle != null) {
            this.getCatalog().remove(myNewStyle);
        }
    }

    @Test
    public void testGetStyleNative() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/styles/v1/styles/PolygonComment");
        TestCase.assertEquals((int)200, (int)response.getStatus());
        TestCase.assertEquals((String)"application/vnd.ogc.sld+xml", (String)response.getContentType());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"This is a testable comment"));
    }

    @Test
    public void testGetStyleNativeExplicitFormat() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/styles/v1/styles/PolygonComment?f=application%2Fvnd.ogc.sld%2Bxml");
        TestCase.assertEquals((int)200, (int)response.getStatus());
        TestCase.assertEquals((String)"application/vnd.ogc.sld+xml", (String)response.getContentType());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"This is a testable comment"));
    }

    @Test
    public void testGetStyleConverted() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/styles/v1/styles/PolygonComment?f=application%2Fvnd.ogc.se%2Bxml");
        TestCase.assertEquals((int)200, (int)response.getStatus());
        TestCase.assertEquals((String)"application/vnd.ogc.se+xml", (String)response.getContentType());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"This is a testable comment")));
    }

    @Test
    public void testPutOnExistingStyle() throws Exception {
        StyleInfo ponds = this.getCatalog().getStyleByName("Ponds");
        TestCase.assertEquals(null, (String)ponds.getSLD().getStyledLayers()[0].getName());
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePoint.sld"));
        MockHttpServletResponse response = this.putAsServletResponse("ogc/styles/v1/styles/Ponds", sld, "application/vnd.ogc.sld+xml");
        TestCase.assertEquals((int)204, (int)response.getStatus());
        ponds = this.getCatalog().getStyleByName("Ponds");
        TestCase.assertEquals((String)"CookbookSimplePoint", (String)ponds.getSLD().getStyledLayers()[0].getName());
    }

    @Test
    public void testPutOnNewStyle() throws Exception {
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePoint.sld"));
        MockHttpServletResponse response = this.putAsServletResponse("ogc/styles/v1/styles/myNewStyle", sld, "application/vnd.ogc.sld+xml");
        TestCase.assertEquals((int)204, (int)response.getStatus());
        StyleInfo myNewStyle = this.getCatalog().getStyleByName(MY_NEW_STYLE);
        TestCase.assertNotNull((Object)myNewStyle);
        TestCase.assertEquals((String)"CookbookSimplePoint", (String)myNewStyle.getSLD().getStyledLayers()[0].getName());
    }

    @Test
    public void testPutOnNewStyleCharsetIssue() throws Exception {
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePoint.sld"));
        byte[] body = sld != null ? sld.getBytes() : (byte[])null;
        MockHttpServletRequest request = this.createRequest("ogc/styles/v1/styles/myNewStyle");
        request.setMethod("PUT");
        request.setContentType("application/vnd.ogc.sld+xml");
        request.setContent(body);
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)new NonUpdatingServletRequest((HttpServletRequest)request));
        TestCase.assertEquals((int)204, (int)response.getStatus());
        StyleInfo myNewStyle = this.getCatalog().getStyleByName(MY_NEW_STYLE);
        TestCase.assertNotNull((Object)myNewStyle);
        TestCase.assertEquals((String)"CookbookSimplePoint", (String)myNewStyle.getSLD().getStyledLayers()[0].getName());
    }

    @Test
    public void testValidateOnly() throws Exception {
        StyleInfo ponds = this.getCatalog().getStyleByName("Ponds");
        TestCase.assertEquals(null, (String)ponds.getSLD().getStyledLayers()[0].getName());
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePoint.sld"));
        MockHttpServletResponse response = this.putAsServletResponse("ogc/styles/v1/styles/Ponds?validate=only", sld, "application/vnd.ogc.sld+xml");
        TestCase.assertEquals((int)204, (int)response.getStatus());
        ponds = this.getCatalog().getStyleByName("Ponds");
        TestCase.assertEquals(null, (String)ponds.getSLD().getStyledLayers()[0].getName());
    }

    @Test
    public void testPutValidateInvalid() throws Exception {
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePointInvalid.sld"));
        MockHttpServletResponse response = this.putAsServletResponse("ogc/styles/v1/styles/Ponds?validate=only", sld, "application/vnd.ogc.sld+xml");
        TestCase.assertEquals((int)400, (int)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Mark"));
    }

    @Test
    public void testPostNewStyle() throws Exception {
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePoint.sld"));
        MockHttpServletResponse response = this.postAsServletResponse("ogc/styles/v1/styles", sld, "application/vnd.ogc.sld+xml");
        TestCase.assertEquals((int)201, (int)response.getStatus());
        TestCase.assertEquals((String)"http://localhost:8080/geoserver/ogc/styles/v1/styles/SimplePoint", (String)response.getHeader("Location"));
        StyleInfo myNewStyle = this.getCatalog().getStyleByName(SIMPLE_POINT);
        TestCase.assertNotNull((Object)myNewStyle);
        TestCase.assertEquals((String)"CookbookSimplePoint", (String)myNewStyle.getSLD().getStyledLayers()[0].getName());
    }

    @Test
    public void testPostNewStyleNoCharset() throws Exception {
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePoint.sld"));
        MockHttpServletRequest request = this.createRequest("ogc/styles/v1/styles");
        request.setMethod("POST");
        request.setContentType("application/vnd.ogc.sld+xml");
        request.setContent(sld.getBytes("UTF-8"));
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)new NonUpdatingServletRequest((HttpServletRequest)request));
        TestCase.assertEquals((int)201, (int)response.getStatus());
        TestCase.assertEquals((String)"http://localhost:8080/geoserver/ogc/styles/v1/styles/SimplePoint", (String)response.getHeader("Location"));
        StyleInfo myNewStyle = this.getCatalog().getStyleByName(SIMPLE_POINT);
        TestCase.assertNotNull((Object)myNewStyle);
        TestCase.assertEquals((String)"CookbookSimplePoint", (String)myNewStyle.getSLD().getStyledLayers()[0].getName());
    }

    @Test
    public void testPostConflict() throws Exception {
        this.testPostNewStyle();
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePoint.sld"));
        MockHttpServletResponse response = this.postAsServletResponse("ogc/styles/v1/styles", sld, "application/vnd.ogc.sld+xml");
        TestCase.assertEquals((int)409, (int)response.getStatus());
    }

    @Test
    public void testPostAutoGenerateName() throws Exception {
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePointNoName.sld"));
        MockHttpServletResponse response = this.postAsServletResponse("ogc/styles/v1/styles", sld, "application/vnd.ogc.sld+xml");
        TestCase.assertEquals((int)201, (int)response.getStatus());
        String location = response.getHeader("Location");
        String urlBase = "http://localhost:8080/geoserver/ogc/styles/v1/styles/";
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.allOf((Matcher)Matchers.startsWith((String)(urlBase + "style-")), (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)(urlBase + "style-")))));
        String styleName = location.substring(urlBase.length());
        StyleInfo myNewStyle = this.getCatalog().getStyleByName(styleName);
        TestCase.assertNotNull((Object)myNewStyle);
        TestCase.assertEquals((String)"CookbookSimplePoint", (String)myNewStyle.getSLD().getStyledLayers()[0].getName());
    }

    @Test
    public void testPostValidateInvalid() throws Exception {
        String sld = IOUtils.toString((InputStream)StyleTest.class.getResourceAsStream("simplePointInvalid.sld"));
        MockHttpServletResponse response = this.postAsServletResponse("ogc/styles/v1/styles?validate=only", sld, "application/vnd.ogc.sld+xml");
        TestCase.assertEquals((int)400, (int)response.getStatus());
        MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Mark"));
    }

    @Test
    public void testStyleDelete() throws Exception {
        this.testPostNewStyle();
        MockHttpServletResponse response = this.deleteAsServletResponse("ogc/styles/v1/styles/SimplePoint");
        TestCase.assertEquals((int)204, (int)response.getStatus());
        response = this.deleteAsServletResponse("ogc/styles/v1/styles/SimplePoint");
        TestCase.assertEquals((int)404, (int)response.getStatus());
    }

    static final class NonUpdatingServletRequest
    extends HttpServletRequestWrapper {
        String characterEncoding;

        public NonUpdatingServletRequest(HttpServletRequest request) {
            super(request);
        }

        public String getCharacterEncoding() {
            return this.characterEncoding;
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this.characterEncoding = enc;
        }
    }
}

