/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Iterator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.StyleDocument;
import org.geoserver.ogcapi.v1.styles.StyleDocumentCallback;
import org.geoserver.platform.ServiceException;
import org.geotools.api.filter.Filter;

@JsonPropertyOrder(value={"styles", "links"})
public class StylesDocument
extends AbstractDocument {
    private final Catalog catalog;

    public StylesDocument(Catalog catalog) {
        this.catalog = catalog;
        this.addSelfLinks("ogc/styles/v1/styles");
    }

    public Iterator<StyleDocument> getStyles() {
        final CloseableIterator styles = this.catalog.list(StyleInfo.class, (Filter)Filter.INCLUDE);
        return new Iterator<StyleDocument>(){
            StyleDocument next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                boolean hasNext = styles.hasNext();
                if (!hasNext) {
                    styles.close();
                    return false;
                }
                try {
                    StyleInfo style = (StyleInfo)styles.next();
                    StyleDocument styleDocument = new StyleDocument(style);
                    StyleDocumentCallback.addStyleLinks(styleDocument);
                    this.next = styleDocument;
                    return true;
                }
                catch (Exception e) {
                    styles.close();
                    throw new ServiceException("Failed to iterate over the feature types in the catalog", (Throwable)e);
                }
            }

            @Override
            public StyleDocument next() {
                StyleDocument result = this.next;
                this.next = null;
                return result;
            }
        };
    }
}

