/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.RestException;
import org.geoserver.rest.converters.StyleWriterConverter;
import org.geotools.util.Version;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class StylesInfoConverter
implements HttpMessageConverter<StyleInfo> {
    private final GeoServerDataDirectory dataDirectory;
    private final List<StyleHandler> handlers;
    Map<MediaType, StyleWriterConverter> writers = new HashMap<MediaType, StyleWriterConverter>();
    List<MediaType> mediaTypes = new ArrayList<MediaType>();

    public StylesInfoConverter(GeoServerExtensions extensions, GeoServerDataDirectory dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.handlers = GeoServerExtensions.extensions(StyleHandler.class);
        for (StyleHandler sh : this.handlers) {
            for (Version ver : sh.getVersions()) {
                String mimeType = sh.mimeType(ver);
                MediaType mediaType = MediaType.valueOf((String)mimeType);
                this.writers.put(mediaType, new StyleWriterConverter(mimeType, ver, sh));
                this.mediaTypes.add(mediaType);
            }
        }
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return StyleInfo.class.isAssignableFrom(clazz) && (mediaType == null || this.getWriter(mediaType).isPresent());
    }

    private Optional<StyleWriterConverter> getWriter(MediaType mediaType) {
        return this.writers.entrySet().stream().filter(e -> ((MediaType)e.getKey()).isCompatibleWith(mediaType)).map(e -> (StyleWriterConverter)e.getValue()).findFirst();
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.mediaTypes);
    }

    public StyleInfo read(Class<? extends StyleInfo> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    public void write(StyleInfo styleInfo, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (contentType == null || contentType.isCompatibleWith(this.getNativeMediaType(styleInfo))) {
            this.copyDefinition(styleInfo, outputMessage.getBody());
        } else {
            StyleWriterConverter writer = this.getWriter(contentType).orElseThrow(() -> new RestException("Cannot write style as " + this.mediaTypes, HttpStatus.UNSUPPORTED_MEDIA_TYPE));
            writer.write((Object)styleInfo, contentType, outputMessage);
        }
    }

    private MediaType getNativeMediaType(StyleInfo styleInfo) {
        String format = styleInfo.getFormat();
        if (format == null) {
            return MediaType.valueOf((String)"application/vnd.ogc.sld+xml");
        }
        StyleHandler handler = this.handlers.stream().filter(sh -> styleInfo.getFormat().equals(sh.getFormat())).findFirst().orElseThrow(() -> new RestException("Could not find style handler for style " + styleInfo.prefixedName(), HttpStatus.INTERNAL_SERVER_ERROR));
        Version version = styleInfo.getFormatVersion();
        if (version == null) {
            version = (Version)handler.getVersions().get(0);
        }
        return MediaType.valueOf((String)handler.mimeType(version));
    }

    void copyDefinition(StyleInfo style, OutputStream out) throws IOException {
        Resource resource = this.dataDirectory.style(style);
        try (InputStream in = resource.in();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }
}

