/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import io.swagger.v3.oas.models.OpenAPI;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ogcapi.APIContentNegotiationManager;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.HTMLResponseBody;
import org.geoserver.ogcapi.ResourceNotFoundException;
import org.geoserver.ogcapi.v1.styles.SampleDataSupport;
import org.geoserver.ogcapi.v1.styles.StyleDates;
import org.geoserver.ogcapi.v1.styles.StyleMetadataDocument;
import org.geoserver.ogcapi.v1.styles.StyleMetadataInfo;
import org.geoserver.ogcapi.v1.styles.StylesAPIBuilder;
import org.geoserver.ogcapi.v1.styles.StylesDocument;
import org.geoserver.ogcapi.v1.styles.StylesLandingPage;
import org.geoserver.ogcapi.v1.styles.StylesServiceInfo;
import org.geoserver.ogcapi.v1.styles.ThumbnailBuilder;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.RestException;
import org.geoserver.rest.converters.StyleWriterConverter;
import org.geoserver.rest.util.IOUtils;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.util.Version;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.xml.sax.EntityResolver;

@APIService(service="Styles", version="1.0.1", landingPage="ogc/styles/v1", serviceClass=StylesServiceInfo.class)
@RequestMapping(path={"ogc/styles/v1"})
public class StylesService {
    private static final String INVALID_STYLE = "InvalidStyle";
    private static final String INVALID_METADATA = "InvalidMetadata";
    public static final String CORE = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/core";
    public static final String HTML = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/html";
    public static final String JSON = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/json";
    public static final String MANAGE = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/manage-styles";
    public static final String VALIDATION = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/style-validation";
    public static final String RESOURCES = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/resources";
    public static final String MANAGE_RESOURCES = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/manage-resources";
    public static final String MAPBOX = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/mapbox-styles";
    public static final String SLD10 = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/sld-10";
    public static final String SLD11 = "http://www.opengis.net/t15/opf-styles-1/1.0/conf/sld-11";
    public static final String CSS = "http://www.geoserver.org/opf-styles-1/1.0/conf/geocss";
    private static final String DISPLAY_NAME = "OGC API Styles";
    private final GeoServer geoServer;
    private final GeoServerDataDirectory dataDirectory;
    private final SampleDataSupport sampleDataSupport;
    private ThumbnailBuilder thumbnailBuilder;
    private Map<MediaType, StyleWriterConverter> writers = new HashMap<MediaType, StyleWriterConverter>();
    private List<MediaType> mediaTypes = new ArrayList<MediaType>();
    private APIContentNegotiationManager contentNegotiationManager = new APIContentNegotiationManager();

    public StylesService(GeoServer geoServer, GeoServerExtensions extensions, GeoServerDataDirectory dataDirectory, SampleDataSupport sampleDataSupport, ThumbnailBuilder thumbnailBuilder) {
        this.geoServer = geoServer;
        this.dataDirectory = dataDirectory;
        this.sampleDataSupport = sampleDataSupport;
        this.thumbnailBuilder = thumbnailBuilder;
        List handlers = GeoServerExtensions.extensions(StyleHandler.class);
        for (StyleHandler sh : handlers) {
            for (Version ver : sh.getVersions()) {
                String mimeType = sh.mimeType(ver);
                MediaType mediaType = MediaType.valueOf((String)mimeType);
                this.writers.put(mediaType, new StyleWriterConverter(mimeType, ver, sh));
                this.mediaTypes.add(mediaType);
            }
        }
    }

    @GetMapping(name="getLandingPage")
    @ResponseBody
    @HTMLResponseBody(templateName="landingPage.ftl", fileName="landingPage.html")
    public StylesLandingPage getLandingPage() {
        StylesServiceInfo styles = this.getService();
        return new StylesLandingPage(styles.getTitle() == null ? "Styles server" : styles.getTitle(), styles.getAbstract() == null ? "" : styles.getAbstract());
    }

    public StylesServiceInfo getService() {
        return (StylesServiceInfo)this.geoServer.getService(StylesServiceInfo.class);
    }

    public StylesServiceInfo getServiceInfo() {
        return this.getService();
    }

    @GetMapping(path={"conformance"}, name="getConformanceDeclaration")
    @ResponseBody
    @HTMLResponseBody(templateName="conformance.ftl", fileName="conformance.html")
    public ConformanceDocument conformance() {
        List<String> classes = Arrays.asList(CORE, HTML, JSON, MAPBOX, SLD10, SLD11);
        return new ConformanceDocument(DISPLAY_NAME, classes);
    }

    @GetMapping(path={"openapi", "openapi.json", "openapi.yaml"}, name="getApi", produces={"application/vnd.oai.openapi+json;version=3.0", "application/yaml", "text/xml"})
    @ResponseBody
    @HTMLResponseBody(templateName="api.ftl", fileName="api.html")
    public OpenAPI api() throws IOException {
        return new StylesAPIBuilder().build(this.getService());
    }

    @GetMapping(path={"styles"}, name="getStyleSet")
    @ResponseBody
    @HTMLResponseBody(templateName="styles.ftl", fileName="styles.html")
    public StylesDocument getStyles() {
        return new StylesDocument(this.geoServer.getCatalog());
    }

    @GetMapping(path={"styles/{styleId}"}, name="getStyle")
    public void getStyle(@PathVariable(name="styleId") String styleId, NativeWebRequest request, HttpServletResponse response) throws HttpMediaTypeNotAcceptableException, IOException {
        StyleInfo styleInfo = this.getStyleInfo(styleId, true);
        MediaType nativeMediaType = this.getNativeMediaType(styleInfo);
        List requestedMediaTypes = this.contentNegotiationManager.resolveMediaTypes(request);
        if (requestedMediaTypes == null || ContentNegotiationStrategy.MEDIA_TYPE_ALL_LIST.equals(requestedMediaTypes)) {
            this.writeNativeToResponse(response, styleInfo, nativeMediaType);
            return;
        }
        for (MediaType requestedMediaType : requestedMediaTypes) {
            if (requestedMediaType.isCompatibleWith(nativeMediaType)) {
                this.writeNativeToResponse(response, styleInfo, nativeMediaType);
                return;
            }
            Optional<StyleWriterConverter> osh = this.getWriter(requestedMediaType);
            if (!osh.isPresent()) continue;
            StyleWriterConverter writer = osh.get();
            String fileName = styleId + "." + writer.getHandler().getFileExtension();
            response.setHeader("Content-Disposition", "inline; filename=" + fileName);
            writer.write((Object)styleInfo, MediaType.valueOf((String)writer.getHandler().mimeType(writer.getVersion())), (HttpOutputMessage)new ServletServerHttpResponse(response));
            return;
        }
        throw new RestException("Could not find a stle encoder for requested media types " + requestedMediaTypes, HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    private StyleInfo getStyleInfo(String styleId, boolean failIfNotFound) {
        StyleInfo style = this.geoServer.getCatalog().getStyleByName(styleId);
        if (style == null) {
            if (failIfNotFound) {
                throw new ResourceNotFoundException("Could not locate style " + styleId);
            }
            return null;
        }
        return style;
    }

    public void writeNativeToResponse(HttpServletResponse response, StyleInfo styleInfo, MediaType nativeMediaType) throws IOException {
        response.setContentType(nativeMediaType.toString());
        response.setStatus(200);
        Resource resource = this.dataDirectory.style(styleInfo);
        try (InputStream in = resource.in();){
            org.apache.commons.io.IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
    }

    private MediaType getNativeMediaType(StyleInfo styleInfo) {
        String format = styleInfo.getFormat();
        if (format == null) {
            return MediaType.valueOf((String)"application/vnd.ogc.sld+xml");
        }
        StyleHandler handler = this.writers.values().stream().map(sw -> sw.getHandler()).filter(sh -> styleInfo.getFormat().equals(sh.getFormat())).findFirst().orElseThrow(() -> new RestException("Could not find style handler for style " + styleInfo.prefixedName(), HttpStatus.INTERNAL_SERVER_ERROR));
        Version version = styleInfo.getFormatVersion();
        if (version == null) {
            version = (Version)handler.getVersions().get(0);
        }
        return MediaType.valueOf((String)handler.mimeType(version));
    }

    private Optional<StyleWriterConverter> getWriter(MediaType mediaType) {
        return this.writers.entrySet().stream().filter(e -> ((MediaType)e.getKey()).isCompatibleWith(mediaType)).map(e -> (StyleWriterConverter)e.getValue()).findFirst();
    }

    @GetMapping(path={"styles/{styleId}/metadata"}, name="getStyleMetadata")
    @ResponseBody
    @HTMLResponseBody(templateName="styleMetadata.ftl", fileName="styleMetadata.html")
    public StyleMetadataDocument getStyleMetadata(@PathVariable(name="styleId") String styleId) throws IOException {
        StyleInfo styleInfo = this.getStyleInfo(styleId, true);
        return new StyleMetadataDocument(styleInfo, this.geoServer, this.sampleDataSupport, this.thumbnailBuilder);
    }

    @GetMapping(path={"styles/{styleId}/thumbnail"}, name="getStyleThumbnail", produces={"image/png"})
    @ResponseBody
    public void getStyleThumbnail(@PathVariable(name="styleId") String styleId, HttpServletResponse response) throws IOException {
        StyleInfo styleInfo = this.getStyleInfo(styleId, true);
        RenderedImage image = this.thumbnailBuilder.buildThumbnailFor(styleInfo);
        if (image == null) {
            throw new APIException("NoApplicableCode", "Failed to build thumbnail, WMS returned no image", HttpStatus.INTERNAL_SERVER_ERROR);
        }
        response.setHeader("Content-Type", "image/png");
        ImageIO.write(image, "PNG", (OutputStream)response.getOutputStream());
    }

    @PostMapping(path={"styles"}, name="addStyle", consumes={"*/*"})
    @ResponseBody
    public ResponseEntity postStyle(InputStream inputStream, @RequestParam(name="validate", required=false, defaultValue="no") ValidationMode validate, HttpServletRequest request) throws IOException {
        MediaType mediaType = MediaType.parseMediaType((String)request.getContentType());
        String mimeType = mediaType.getType() + "/" + mediaType.getSubtype();
        byte[] rawData = IOUtils.toByteArray((InputStream)inputStream);
        String charsetName = this.getCharacterEncoding(request);
        String content = new String(rawData, charsetName);
        StyleHandler handler = this.getHandler(mimeType);
        if (validate == ValidationMode.only || validate == ValidationMode.yes) {
            this.validate(mimeType, content, handler);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        String styleId = this.getStyleId(mimeType, handler, content);
        StyleInfo styleInfo = this.getStyleInfo(styleId, false);
        if (styleInfo != null) {
            throw new APIException("Conflict", "Style with id " + styleId + " already exists", HttpStatus.CONFLICT);
        }
        Catalog catalog = this.geoServer.getCatalog();
        styleInfo = catalog.getFactory().createStyle();
        styleInfo.setName(styleId);
        styleInfo.setFilename(styleId + "." + handler.getFileExtension());
        styleInfo.setFormat(handler.getFormat());
        styleInfo.setFormatVersion(handler.versionForMimeType(mimeType));
        if (LocalWorkspace.get() != null) {
            styleInfo.setWorkspace(catalog.getWorkspaceByName(LocalWorkspace.get().getName()));
        }
        catalog.add(styleInfo);
        catalog.getResourcePool().writeStyle(styleInfo, (InputStream)new ByteArrayInputStream(rawData));
        HttpHeaders headers = new HttpHeaders();
        String href = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/styles/v1/styles/" + styleId), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        headers.set((Object)"Location", (Object)href);
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.CREATED);
    }

    private String getCharacterEncoding(HttpServletRequest request) {
        return Optional.ofNullable(request.getCharacterEncoding()).map(Object::toString).orElseGet(() -> Optional.ofNullable(this.geoServer.getSettings().getCharset()).orElse("UTF-8"));
    }

    private String getStyleId(String mimeType, StyleHandler handler, String content) throws IOException {
        Catalog catalog = this.geoServer.getCatalog();
        EntityResolver entityResolver = catalog.getResourcePool().getEntityResolver();
        StyledLayerDescriptor sld = handler.parse((Object)content, handler.versionForMimeType(mimeType), null, entityResolver);
        String name = sld.getName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return "style-" + UUID.randomUUID();
    }

    @PutMapping(path={"styles/{styleId}"}, consumes={"*/*"}, name="updateStyle")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void putStyle(InputStream inputStream, @PathVariable String styleId, @RequestParam(name="validate", required=false, defaultValue="no") ValidationMode validate, HttpServletRequest request) throws IOException {
        MediaType mediaType = MediaType.parseMediaType((String)request.getContentType());
        String mimeType = mediaType.getType() + "/" + mediaType.getSubtype();
        byte[] rawData = IOUtils.toByteArray((InputStream)inputStream);
        String charsetName = this.getCharacterEncoding(request);
        String content = new String(rawData, charsetName);
        StyleHandler handler = this.getHandler(mimeType);
        if (validate == ValidationMode.only || validate == ValidationMode.yes) {
            this.validate(mimeType, content, handler);
        }
        if (validate != ValidationMode.only) {
            StyleInfo styleInfo = this.getStyleInfo(styleId, false);
            Catalog catalog = this.geoServer.getCatalog();
            if (styleInfo == null) {
                styleInfo = catalog.getFactory().createStyle();
                styleInfo.setName(styleId);
                styleInfo.setFilename(styleId + "." + handler.getFileExtension());
                styleInfo.setFormat(handler.getFormat());
                styleInfo.setFormatVersion(handler.versionForMimeType(mimeType));
                if (LocalWorkspace.get() != null) {
                    styleInfo.setWorkspace(catalog.getWorkspaceByName(LocalWorkspace.get().getName()));
                }
                catalog.add(styleInfo);
            } else {
                styleInfo.setFormat(handler.getFormat());
                styleInfo.setFormatVersion(handler.versionForMimeType(mimeType));
                catalog.save(styleInfo);
            }
            catalog.getResourcePool().writeStyle(styleInfo, (InputStream)new ByteArrayInputStream(rawData));
        }
    }

    public void validate(String mimeType, String content, StyleHandler handler) {
        try {
            Catalog catalog = this.geoServer.getCatalog();
            EntityResolver entityResolver = catalog.getResourcePool().getEntityResolver();
            List errors = handler.validate((Object)content, handler.versionForMimeType(mimeType), entityResolver);
            if (errors != null && !errors.isEmpty()) {
                throw new APIException(INVALID_STYLE, "Invalid style:" + errors, HttpStatus.BAD_REQUEST);
            }
        }
        catch (Exception invalid) {
            throw new APIException(INVALID_STYLE, "Invalid style:" + invalid.getMessage(), HttpStatus.BAD_REQUEST, (Throwable)invalid);
        }
    }

    public StyleHandler getHandler(String mimeType) {
        StyleHandler handler;
        try {
            handler = Styles.handler((String)mimeType);
        }
        catch (Exception e) {
            throw new APIException("Illegal input media type", "Failed to lookup style support for media type " + mimeType, HttpStatus.BAD_REQUEST, (Throwable)e);
        }
        return handler;
    }

    @DeleteMapping(path={"styles/{styleId}"}, name="deleteStyle")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteStyle(@PathVariable(name="styleId") String styleId) {
        StyleInfo styleInfo = this.getStyleInfo(styleId, true);
        this.geoServer.getCatalog().remove(styleInfo);
    }

    @PutMapping(path={"styles/{styleId}/metadata"}, name="updateStyleMetadata")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void putStyleMetadata(@PathVariable(value="styleId") String styleId, @RequestBody StyleMetadataDocument metadata) throws IOException {
        StyleInfo styleInfo = this.getStyleInfo(styleId, true);
        StyleMetadataInfo metadataInfo = Optional.ofNullable((StyleMetadataInfo)styleInfo.getMetadata().get(StyleMetadataInfo.METADATA_KEY, StyleMetadataInfo.class)).orElse(new StyleMetadataInfo());
        if (metadata.getId() != null && !styleId.equals(metadata.getId())) {
            throw new APIException(INVALID_METADATA, "Style id must be " + styleId, HttpStatus.BAD_REQUEST);
        }
        metadataInfo.setAbstract(metadata.getDescription());
        metadataInfo.setAccessConstraints(metadata.getAccessConstraints());
        metadataInfo.setKeywords(metadata.getKeywords());
        metadataInfo.setPointOfContact(metadata.getPointOfContact());
        metadataInfo.setTitle(metadata.getTitle());
        metadataInfo.setDates(metadata.getDates());
        styleInfo.getMetadata().put(StyleMetadataInfo.METADATA_KEY, (Serializable)metadataInfo);
        this.geoServer.getCatalog().save(styleInfo);
    }

    @PatchMapping(path={"styles/{styleId}/metadata"}, consumes={"application/json"}, name="patchStyleMetadata")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchMetadata(@PathVariable(value="styleId") String styleId, @RequestBody StyleMetadataDocument metadata) {
        StyleInfo styleInfo = this.getStyleInfo(styleId, true);
        StyleMetadataInfo metadataInfo = Optional.ofNullable((StyleMetadataInfo)styleInfo.getMetadata().get(StyleMetadataInfo.METADATA_KEY, StyleMetadataInfo.class)).orElse(new StyleMetadataInfo());
        if (metadata.isDescriptionSet()) {
            metadataInfo.setAbstract(metadata.getDescription());
        }
        if (metadata.isAccessConstraintsSet()) {
            metadataInfo.setAccessConstraints(metadata.getAccessConstraints());
        }
        if (metadata.isKeywordsSet()) {
            metadataInfo.setKeywords(metadata.getKeywords());
        }
        if (metadata.isPointOfContactSet()) {
            metadataInfo.setPointOfContact(metadata.getPointOfContact());
        }
        if (metadata.isTitleSet()) {
            metadataInfo.setTitle(metadata.getTitle());
        }
        if (metadata.isDatesSet() || metadata.getDates() != null) {
            StyleDates inputDates = metadata.getDates();
            StyleDates dates = Optional.ofNullable(metadataInfo.getDates()).orElse(new StyleDates());
            if (inputDates.isCreationSet()) {
                dates.setCreation(inputDates.getCreation());
            }
            if (inputDates.isPublicationSet()) {
                dates.setPublication(inputDates.getPublication());
            }
            if (inputDates.isReceivedOnSet()) {
                dates.setReceivedOn(inputDates.getReceivedOn());
            }
            if (inputDates.isRevisionSet()) {
                dates.setRevision(inputDates.getRevision());
            }
            if (inputDates.isValidTillSet()) {
                dates.setValidTill(inputDates.getValidTill());
            }
            metadataInfo.setDates(dates);
        }
        styleInfo.getMetadata().put(StyleMetadataInfo.METADATA_KEY, (Serializable)metadataInfo);
        this.geoServer.getCatalog().save(styleInfo);
    }

    static enum ValidationMode {
        yes,
        no,
        only;

    }
}

