/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.styles;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Optional;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.util.Version;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"title", "version", "specification", "native", "tilingScheme", "link"})
public class Stylesheet
extends AbstractDocument {
    private String title;
    private String version;
    private String specification;
    private boolean nativ;
    private String tilingScheme;
    private Link link;

    public Stylesheet(StyleInfo info, StyleHandler handler, Version version) throws MalformedURLException {
        this.title = "Stylesheet as " + handler.getName() + " " + version;
        this.version = version.toString();
        this.specification = Optional.ofNullable(handler.getSpecification(version)).map(URL::toExternalForm).orElse(null);
        this.nativ = this.isNative(info, handler, version);
        if (handler.getFormat().equals("MBStyle")) {
            this.tilingScheme = "http://www.opengis.net/def/wkss/OGC/1.0/GoogleMapsCompatible";
        }
        String baseURL = APIRequestInfo.get().getBaseURL();
        String styleId = info.prefixedName();
        String mimeType = handler.mimeType(version);
        String url = ResponseUtils.buildURL((String)baseURL, (String)("ogc/styles/v1/styles/" + ResponseUtils.urlEncode((String)styleId, (char[])new char[0])), Collections.singletonMap("f", mimeType), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        this.link = new Link(url, "stylesheet", mimeType, null);
    }

    private boolean isNative(StyleInfo info, StyleHandler handler, Version version) {
        if (info.getFormat() == null) {
            return handler instanceof SLDHandler && SLDHandler.VERSION_10.equals((Object)version);
        }
        if (!info.getFormat().equals(handler.getFormat())) {
            return false;
        }
        return info.getFormatVersion() == null && version.equals(handler.getVersions().get(0)) || info.getFormatVersion() != null && info.getFormatVersion().equals((Object)version);
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSpecification() {
        return this.specification;
    }

    public boolean isNative() {
        return this.nativ;
    }

    public String getTilingScheme() {
        return this.tilingScheme;
    }

    public Link getLink() {
        return this.link;
    }
}

