/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features.tiled;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.servers.Server;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.ogcapi.v1.features.tiled.TiledFeaturesTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class ApiTest
extends TiledFeaturesTestSupport {
    @Test
    public void testApiJson() throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse("ogc/features/v1/openapi", 200);
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.startsWith((String)"application/vnd.oai.openapi+json;version=3.0"));
        String json = response.getContentAsString();
        LOGGER.log(Level.INFO, json);
        ObjectMapper mapper = Json.mapper();
        OpenAPI api = (OpenAPI)mapper.readValue(json, OpenAPI.class);
        this.validateApi(api);
    }

    private void validateApi(OpenAPI api) {
        List servers = api.getServers();
        MatcherAssert.assertThat((Object)servers, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Server)servers.get(0)).getUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/features/v1"));
        Paths paths = api.getPaths();
        PathItem tileMatrixSets = (PathItem)paths.get((Object)"/tileMatrixSets");
        Assert.assertNotNull((Object)tileMatrixSets);
        MatcherAssert.assertThat((Object)tileMatrixSets.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getTileMatrixSets"));
        PathItem tileMatrixSet = (PathItem)paths.get((Object)"/tileMatrixSets/{tileMatrixSetId}");
        Assert.assertNotNull((Object)tileMatrixSet);
        MatcherAssert.assertThat((Object)tileMatrixSet.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getTileMatrixSetDescription"));
        PathItem tiles = (PathItem)paths.get((Object)"/collections/{collectionId}/tiles/{tileMatrixSetId}/{tileMatrix}/{tileRow}/{tileCol}");
        Assert.assertNotNull((Object)tiles);
        MatcherAssert.assertThat((Object)tiles.getGet().getOperationId(), (Matcher)CoreMatchers.equalTo((Object)"getTileOfCollectionId"));
    }
}

