/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features.tiled;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.ogcapi.v1.features.FeatureService;
import org.geoserver.ogcapi.v1.features.tiled.TiledFeaturesTestSupport;
import org.geoserver.platform.Service;
import org.geotools.util.Version;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class LandingPageTest
extends TiledFeaturesTestSupport {
    @Test
    public void testServiceDescriptor() {
        Service service = this.getService("Features", new Version("1.0.1"));
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)"Features", (Object)service.getId());
        Assert.assertEquals((Object)new Version("1.0.1"), (Object)service.getVersion());
        MatcherAssert.assertThat((Object)service.getService(), (Matcher)CoreMatchers.instanceOf(FeatureService.class));
        MatcherAssert.assertThat((Object)service.getOperations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"getApi", "describeCollection", "getCollections", "getConformanceDeclaration", "getFeature", "getFeatures", "searchFeatures", "getLandingPage", "getQueryables", "getFunctions", "getTileMatrixSets", "getTileMatrixSet", "describeTileset", "describeTilesets", "getTile", "getTilesMetadata", "getJSONFGSchemas"}));
    }

    @Test
    public void testLandingPageExtension() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/v1", 200);
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/features\\/v1\\/collections.*/)].rel", new String[]{"data", "data", "data"});
        this.assertJSONList(json, "links[?(@.href =~ /.*ogc\\/features\\/v1\\/tileMatrixSets.*/)].rel", new String[]{"http://www.opengis.net/def/rel/ogc/1.0/tiling-schemes", "http://www.opengis.net/def/rel/ogc/1.0/tiling-schemes", "http://www.opengis.net/def/rel/ogc/1.0/tiling-schemes"});
        Assert.assertEquals((Object)"Features 1.0 server", (Object)json.read("title", new Predicate[0]));
    }

    @Test
    public void testLandingPageExtensionHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/features/v1?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/v1/tileMatrixSets?f=text%2Fhtml", (Object)document.select("#tileMatrixSetsLink").attr("href"));
    }
}

