/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features.tiled;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.features.tiled.TiledFeaturesTestSupport;
import org.geoserver.ogcapi.v1.tiles.Tileset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TilesetsDescriptionTest
extends TiledFeaturesTestSupport {
    @Test
    public void testGetTileMatrixSets() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/tileMatrixSets", 200);
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/features\\/v1\\/tileMatrixSets\\?.*/)].rel", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"self"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/features\\/v1\\/tileMatrixSets\\?.*/ && @.rel == 'alternate')].type", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"application/yaml"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("tileMatrixSets[*].id", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"GlobalCRS84Pixel", "EPSG:4326", "EPSG:900913"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("tileMatrixSets[?(@.id == 'EPSG:4326')].links[?(@.type == 'application/json')].href", new Predicate[0])), (Matcher)Matchers.contains((Object[])new String[]{"http://localhost:8080/geoserver/ogc/tiles/v1/tileMatrixSets/EPSG%3A4326?f=application%2Fjson"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("tileMatrixSets[?(@.id == 'EPSG:4326')].links[?(@.type == 'application/json')].rel", new Predicate[0])), (Matcher)Matchers.contains((Object[])new String[]{"tileMatrixSet"}));
    }

    @Test
    public void testGetTileMatrixSetsHTML() throws Exception {
        this.getAsJSoup("ogc/features/v1/tileMatrixSets?f=html");
    }

    @Test
    public void testGetTileMatrixSet() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/tileMatrixSets/EPSG:4326", 200);
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/features\\/v1\\/tileMatrixSets\\/EPSG%3A4326\\?.*/)].rel", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"self"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/features\\/v1\\/tileMatrixSets\\/EPSG%3A4326\\?.*/ && @.rel == 'alternate')].type", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"application/yaml"}));
        MatcherAssert.assertThat((Object)((String)json.read("id", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"EPSG:4326"));
        MatcherAssert.assertThat((Object)((String)json.read("supportedCRS", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84"));
        MatcherAssert.assertThat((Object)((String)json.read("title", new Predicate[0])), (Matcher)Matchers.startsWith((String)"A default WGS84"));
        MatcherAssert.assertThat((Object)((String)json.read("tileMatrices[0].id", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"EPSG:4326:0"));
        MatcherAssert.assertThat((Object)((Double)json.read("tileMatrices[0].scaleDenominator", Double.class, new Predicate[0])), (Matcher)Matchers.closeTo((double)2.7954112E8, (double)1000.0));
        MatcherAssert.assertThat((Object)((Integer)json.read("tileMatrices[0].tileWidth", new Predicate[0])), (Matcher)Matchers.equalTo((Object)256));
        MatcherAssert.assertThat((Object)((Integer)json.read("tileMatrices[0].tileWidth", new Predicate[0])), (Matcher)Matchers.equalTo((Object)256));
        MatcherAssert.assertThat((Object)((Integer)json.read("tileMatrices[0].matrixWidth", new Predicate[0])), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((Integer)json.read("tileMatrices[0].matrixHeight", new Predicate[0])), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Iterable)json.read("tileMatrices[0].pointOfOrigin", new Predicate[0])), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.closeTo((double)90.0, (double)0.0), Matchers.closeTo((double)-180.0, (double)0.0)}));
    }

    @Test
    public void getDataTilesMetadata() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments + "/tiles", 200);
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/features\\/v1\\/collections\\/cite:RoadSegments\\/tiles\\?.*/)].rel", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"self"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/features\\/v1\\/collections\\/cite:RoadSegments\\/tiles\\?.*/ && @.rel == 'alternate')].type", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"application/yaml"}));
        Assert.assertEquals((Object)2, (Object)json.read("$.tilesets.size()", new Predicate[0]));
        String matrixDefinition = "http://localhost:8080/geoserver/ogc/features/v1/tileMatrixSets/EPSG%3A4326";
        Assert.assertEquals((Object)matrixDefinition, (Object)json.read("$.tilesets[0].tileMatrixSetURI", new Predicate[0]));
        Assert.assertEquals((Object)matrixDefinition, (Object)json.read("$.tilesets[0].tileMatrixSetDefinition", new Predicate[0]));
        Assert.assertEquals((Object)Tileset.DataType.vector.toString(), (Object)json.read("$.tilesets[0].dataType", new Predicate[0]));
        String tilesetLink = (String)this.readSingle(json, "$.tilesets[0].links[?(@.type == 'application/json')].href");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite:RoadSegments/tiles/EPSG:4326?f=application%2Fjson", (Object)tilesetLink);
    }

    @Test
    public void getDataTilesMetadataHTML() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        this.getAsJSoup("ogc/features/v1/collections/" + roadSegments + "/tiles?f=text/html");
    }
}

