/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features.tiled;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.DocumentCallback;
import org.geoserver.ogcapi.FreemarkerTemplateSupport;
import org.geoserver.ogcapi.HTMLExtensionCallback;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ogcapi.OpenAPICallback;
import org.geoserver.ogcapi.v1.features.CollectionDocument;
import org.geoserver.ogcapi.v1.features.CollectionsDocument;
import org.geoserver.ogcapi.v1.features.FeaturesLandingPage;
import org.geoserver.ogcapi.v1.features.tiled.TiledFeatureService;
import org.geoserver.ogcapi.v1.tiles.TileMatrixSets;
import org.geoserver.ogcapi.v1.tiles.TilesDocument;
import org.geoserver.ogcapi.v1.tiles.TilesService;
import org.geoserver.ows.Request;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class TiledFeaturesExtension
implements ApplicationListener<ContextRefreshedEvent>,
OpenAPICallback,
DocumentCallback,
HTMLExtensionCallback {
    private static final String FEATURES = "Features";
    private static final String REQ_COLLECTION = "describeCollection";
    private static final String REQ_COLLECTIONS = "getCollections";
    private static final String REQ_LANDING = "getLandingPage";
    private final FreemarkerTemplateSupport templateSupport;
    private TiledFeatureService tiledFeatures;
    private TilesService tilesService;

    public TiledFeaturesExtension(FreemarkerTemplateSupport templateSupport) {
        this.templateSupport = templateSupport;
    }

    public String getExtension(Request dr, Map<String, Object> model, Charset charset, List htmlExtensionArguments) throws IOException {
        if (dr.getService().equals(FEATURES)) {
            if (dr.getRequest().equals(REQ_LANDING)) {
                return this.templateSupport.processTemplate(null, "landingPageTileMatrixExtension.ftl", this.getClass(), model, charset);
            }
            if (dr.getRequest().equals(REQ_COLLECTION)) {
                HashMap<String, Object> clonedModel = new HashMap<String, Object>(model);
                CollectionDocument collection = (CollectionDocument)model.get("model");
                if (this.tiledFeatures.isTiledVectorLayer(collection.getId())) {
                    clonedModel.put("collection", collection);
                    return this.templateSupport.processTemplate(null, "collectionExtension.ftl", this.getClass(), clonedModel, charset);
                }
            } else if (dr.getRequest().equals(REQ_COLLECTIONS)) {
                HashMap<String, Object> clonedModel = new HashMap<String, Object>(model);
                CollectionDocument collection = (CollectionDocument)htmlExtensionArguments.get(0);
                if (this.tiledFeatures.isTiledVectorLayer(collection.getId())) {
                    clonedModel.put("collection", collection);
                    return this.templateSupport.processTemplate(null, "collectionExtension.ftl", this.getClass(), clonedModel, charset);
                }
            }
        }
        return null;
    }

    public void apply(Request dr, AbstractDocument document) {
        if (dr.getService().equals(FEATURES)) {
            if (document instanceof ConformanceDocument) {
                this.extendConformanceClasses((ConformanceDocument)document);
            } else if (document instanceof CollectionDocument) {
                this.extendCollectionDocument((CollectionDocument)document);
            } else if (document instanceof CollectionsDocument) {
                this.extendCollectionsDocument((CollectionsDocument)document);
            } else if (document instanceof FeaturesLandingPage) {
                this.extendLandingpage(document);
            }
        }
    }

    public void apply(Request dr, OpenAPI target) throws IOException {
        if (dr.getService().equals(FEATURES)) {
            OpenAPI tilesAPI = this.tiledFeatures.tileServiceAPI();
            this.copyPathItem(target, tilesAPI, "/tileMatrixSets");
            this.copyPathItem(target, tilesAPI, "/tileMatrixSets/{tileMatrixSetId}");
            this.copyPathItem(target, tilesAPI, "/collections/{collectionId}/tiles/{tileMatrixSetId}/{tileMatrix}/{tileRow}/{tileCol}");
            this.copyParameter(target, tilesAPI, "f-vector");
        }
    }

    private void copyParameter(OpenAPI target, OpenAPI tilesAPI, String parameterKey) {
        Parameter parameter = (Parameter)tilesAPI.getComponents().getParameters().get(parameterKey);
        if (parameter == null) {
            throw new RuntimeException("Could not find parameter " + parameterKey);
        }
        target.getComponents().getParameters().put(parameterKey, parameter);
    }

    private void copyPathItem(OpenAPI target, OpenAPI tilesAPI, String pathItemKey) {
        PathItem item = (PathItem)tilesAPI.getPaths().get((Object)pathItemKey);
        if (item == null) {
            throw new RuntimeException("Could not find path item " + pathItemKey);
        }
        target.getPaths().addPathItem(pathItemKey, item);
    }

    private void extendLandingpage(AbstractDocument landingPage) {
        new LinksBuilder(TileMatrixSets.class, "ogc/features/v1/tileMatrixSets").title("Tile matrix set list as ").rel("http://www.opengis.net/def/rel/ogc/1.0/tiling-schemes").add(landingPage);
    }

    public void extendConformanceClasses(ConformanceDocument conformance) {
        conformance.getConformsTo().add("http://www.opengis.net/spec/ogcapi-common-1/1.0/conf/core");
        ConformanceDocument cd = this.tilesService.conformance();
        cd.getConformsTo().forEach(c -> {
            if (!conformance.getConformsTo().contains(c)) {
                conformance.getConformsTo().add(c);
            }
        });
    }

    private void extendCollectionDocument(CollectionDocument collection) {
        if (this.tiledFeatures.isTiledVectorLayer(collection.getId())) {
            new LinksBuilder(TilesDocument.class, "ogc/features/v1/collections/").segment(collection.getId(), true).segment("tiles").title("Tiles metadata as ").rel("http://www.opengis.net/def/rel/ogc/1.0/tilesets-vector").add((AbstractDocument)collection);
        }
    }

    private void extendCollectionsDocument(CollectionsDocument collections) {
        collections.addCollectionDecorator(this::extendCollectionDocument);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.tiledFeatures = (TiledFeatureService)event.getApplicationContext().getBean(TiledFeatureService.class);
        this.tilesService = (TilesService)event.getApplicationContext().getBean(TilesService.class);
    }
}

