/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.features.tiled;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.features.tiled.TiledFeaturesTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class CollectionTest
extends TiledFeaturesTestSupport {
    @Test
    public void testCollectionJson() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/features/v1/collections/" + roadSegments, 200);
        Assert.assertEquals((Object)"cite:RoadSegments", (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.title", String.class, new Predicate[0]));
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, "links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/tilesets-vector' && @.type=='application/json')].href")), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite:RoadSegments/tiles?f=application%2Fjson"));
    }

    @Test
    public void testCollectionHtml() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        Document doc = this.getAsJSoup("ogc/features/v1/collections/" + roadSegments + "?f=html");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/features/v1/collections/cite:RoadSegments/tiles?f=text%2Fhtml", (Object)doc.select("#cite__RoadSegments_tiles").attr("href"));
    }

    @Test
    public void testUntiledCollectionHtml() throws Exception {
        String basicPolygons = this.getLayerId(MockData.BASIC_POLYGONS);
        Document doc = this.getAsJSoup("ogc/features/v1/collections/" + basicPolygons + "?f=html");
        MatcherAssert.assertThat((Object)doc.select("#cite__RoadSegments_tiles"), (Matcher)Matchers.empty());
    }
}

