/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.geoserver.data.test.MockData;
import org.geoserver.ogcapi.v1.tiles.TilesTestSupport;
import org.geoserver.ogcapi.v1.tiles.Tileset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TilesetsDescriptionTest
extends TilesTestSupport {
    @Test
    public void testGetTileMatrixSets() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/tileMatrixSets", 200);
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/tileMatrixSets\\?.*/)].rel", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"self"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/tileMatrixSets\\?.*/ && @.rel == 'alternate')].type", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"application/yaml"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("tileMatrixSets[*].id", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"GlobalCRS84Pixel", "EPSG:4326", "EPSG:900913"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("tileMatrixSets[?(@.id == 'EPSG:4326')].links[?(@.type == 'application/json')].href", new Predicate[0])), (Matcher)Matchers.contains((Object[])new String[]{"http://localhost:8080/geoserver/ogc/tiles/v1/tileMatrixSets/EPSG%3A4326?f=application%2Fjson"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("tileMatrixSets[?(@.id == 'EPSG:4326')].links[?(@.type == 'application/json')].rel", new Predicate[0])), (Matcher)Matchers.contains((Object[])new String[]{"tileMatrixSet"}));
    }

    @Test
    public void testGetTileMatrixSetsHTML() throws Exception {
        this.getAsJSoup("ogc/tiles/v1/tileMatrixSets?f=html");
    }

    @Test
    public void testGetTileMatrixSet() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/tileMatrixSets/EPSG:4326", 200);
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/tileMatrixSets\\/EPSG%3A4326\\?.*/)].rel", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"self"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/tileMatrixSets\\/EPSG%3A4326\\?.*/ && @.rel == 'alternate')].type", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"application/yaml"}));
        MatcherAssert.assertThat((Object)((String)json.read("id", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"EPSG:4326"));
        MatcherAssert.assertThat((Object)((String)json.read("supportedCRS", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84"));
        MatcherAssert.assertThat((Object)((String)json.read("title", new Predicate[0])), (Matcher)Matchers.startsWith((String)"A default WGS84"));
        MatcherAssert.assertThat((Object)((String)json.read("tileMatrices[0].id", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"EPSG:4326:0"));
        MatcherAssert.assertThat((Object)((Double)json.read("tileMatrices[0].scaleDenominator", Double.class, new Predicate[0])), (Matcher)Matchers.closeTo((double)2.7954112E8, (double)1000.0));
        MatcherAssert.assertThat((Object)((Integer)json.read("tileMatrices[0].tileWidth", new Predicate[0])), (Matcher)Matchers.equalTo((Object)256));
        MatcherAssert.assertThat((Object)((Integer)json.read("tileMatrices[0].tileWidth", new Predicate[0])), (Matcher)Matchers.equalTo((Object)256));
        MatcherAssert.assertThat((Object)((Integer)json.read("tileMatrices[0].matrixWidth", new Predicate[0])), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)((Integer)json.read("tileMatrices[0].matrixHeight", new Predicate[0])), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((Iterable)json.read("tileMatrices[0].pointOfOrigin", new Predicate[0])), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.closeTo((double)90.0, (double)0.0), Matchers.closeTo((double)-180.0, (double)0.0)}));
    }

    @Test
    public void getDataTilesMetadata() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/tiles/v1/collections/" + roadSegments + "/tiles", 200);
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type == 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/collections\\/cite:RoadSegments\\/tiles\\?.*/)].rel", new Predicate[0])), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"self"}));
        MatcherAssert.assertThat((Object)((Iterable)json.read("links[?(@.type != 'application/json' && @.href =~ /.*ogc\\/tiles\\/v1\\/collections\\/cite:RoadSegments\\/tiles\\?.*/ && @.rel == 'alternate')].type", new Predicate[0])), (Matcher)Matchers.hasItems((Object[])new String[]{"application/yaml"}));
        this.checkRoadSegmentsTileMatrix(json, Tileset.DataType.vector);
    }

    @Test
    public void testTileJSONSingleLayer() throws Exception {
        DocumentContext doc = this.getAsJSONPath("/ogc/tiles/v1/collections/cite:RoadSegments/tiles/EPSG:4326/metadata?f=application%2Fjson", 200);
        MatcherAssert.assertThat((Object)((String)doc.read("name", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"cite:RoadSegments"));
        MatcherAssert.assertThat((Object)((String)doc.read("scheme", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"xyz"));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "tiles")), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite%3ARoadSegments/tiles/EPSG:4326/{z}/{y}/{x}?f=application%2Fvnd.mapbox-vector-tile"));
        MatcherAssert.assertThat((Object)((Integer)doc.read("minzoom", new Predicate[0])), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)((Integer)doc.read("maxzoom", new Predicate[0])), (Matcher)Matchers.equalTo((Object)21));
        MatcherAssert.assertThat((Object)((List)doc.read("center", new Predicate[0])), (Matcher)Matchers.equalTo(Arrays.asList(0.0, 0.0, 0.0)));
        MatcherAssert.assertThat((Object)((List)doc.read("bounds", new Predicate[0])), (Matcher)Matchers.equalTo(Arrays.asList(-0.0042, -0.0024, 0.0042, 0.0024)));
        MatcherAssert.assertThat((Object)((Map)this.readSingle(doc, "vector_layers[?(@.id == 'RoadSegments')].fields")), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"FID", (Object)"string"), (Matcher)Matchers.hasEntry((Object)"NAME", (Object)"string")));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "vector_layers[?(@.id == 'RoadSegments')].geometry_type")), (Matcher)Matchers.equalTo((Object)"line"));
    }

    @Test
    public void testTileJSONLayerGroup() throws Exception {
        DocumentContext doc = this.getAsJSONPath("/ogc/tiles/v1/collections/nature/tiles/EPSG:900913/metadata?f=application%2Fjson", 200);
        MatcherAssert.assertThat((Object)((String)doc.read("name", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"nature"));
        MatcherAssert.assertThat((Object)((String)doc.read("scheme", new Predicate[0])), (Matcher)Matchers.equalTo((Object)"xyz"));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "tiles")), (Matcher)Matchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/nature/tiles/EPSG:900913/{z}/{y}/{x}?f=application%2Fvnd.mapbox-vector-tile"));
        MatcherAssert.assertThat((Object)((Iterable)doc.read("center", new Predicate[0])), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.closeTo((double)0.0, (double)1.0E-6), Matchers.closeTo((double)0.0, (double)1.0E-6), Matchers.closeTo((double)0.0, (double)1.0E-6)}));
        MatcherAssert.assertThat((Object)((List)doc.read("bounds", new Predicate[0])), (Matcher)Matchers.equalTo(Arrays.asList(-180.0, -90.0, 180.0, 90.0)));
        MatcherAssert.assertThat((Object)((Map)this.readSingle(doc, "vector_layers[?(@.id == 'Lakes')].fields")), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"FID", (Object)"string"), (Matcher)Matchers.hasEntry((Object)"NAME", (Object)"string")));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "vector_layers[?(@.id == 'Lakes')].geometry_type")), (Matcher)Matchers.equalTo((Object)"polygon"));
        MatcherAssert.assertThat((Object)((Map)this.readSingle(doc, "vector_layers[?(@.id == 'Forests')].fields")), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"FID", (Object)"string"), (Matcher)Matchers.hasEntry((Object)"NAME", (Object)"string")));
        MatcherAssert.assertThat((Object)((String)this.readSingle(doc, "vector_layers[?(@.id == 'Forests')].geometry_type")), (Matcher)Matchers.equalTo((Object)"polygon"));
    }

    public void checkRoadSegmentsTileMatrix(DocumentContext json, Tileset.DataType dataType) {
        Assert.assertEquals((Object)2, (Object)json.read("$.tilesets.size()", new Predicate[0]));
        String matrixDefinition = "http://localhost:8080/geoserver/ogc/tiles/v1/tileMatrixSets/EPSG%3A4326";
        Assert.assertEquals((Object)matrixDefinition, (Object)json.read("$.tilesets[0].tileMatrixSetURI", new Predicate[0]));
        Assert.assertEquals((Object)matrixDefinition, (Object)json.read("$.tilesets[0].tileMatrixSetDefinition", new Predicate[0]));
        Assert.assertEquals((Object)dataType.toString(), (Object)json.read("$.tilesets[0].dataType", new Predicate[0]));
        String tilesetLink = (String)this.readSingle(json, "$.tilesets[0].links[?(@.type == 'application/json')].href");
        if (dataType == Tileset.DataType.map) {
            Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:RoadSegments/map/tiles/EPSG:4326?f=application%2Fjson", (Object)tilesetLink);
        } else if (dataType == Tileset.DataType.vector) {
            Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/tiles/v1/collections/cite:RoadSegments/tiles/EPSG:4326?f=application%2Fjson", (Object)tilesetLink);
        }
    }
}

