/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AttributeType;
import org.geoserver.ogcapi.InvalidParameterValueException;
import org.geoserver.ogcapi.ResourceNotFoundException;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.capabilities.CapabilityUtil;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.NumberRange;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileJSONProvider;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.layer.meta.VectorLayerMetadata;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class TileJSONBuilder {
    String collectionId;
    String styleId;
    String tileFormat;
    String tileMatrixSetId;
    TileLayer tileLayer;

    public TileJSONBuilder(String collectionId, String tileFormat, String tileMatrixSetId, TileLayer tileLayer) {
        this.collectionId = collectionId;
        this.tileFormat = tileFormat;
        this.tileMatrixSetId = tileMatrixSetId;
        this.tileLayer = tileLayer;
    }

    public TileJSONBuilder style(String styleId) {
        this.styleId = styleId;
        return this;
    }

    public TileJSON build() throws FactoryException, TransformException, IOException {
        String description;
        String tilesURL;
        boolean isVector;
        TileJSON tileJSON = new TileJSON();
        tileJSON.setName(this.collectionId);
        GridSubset subset = this.tileLayer.getGridSubset(this.tileMatrixSetId);
        if (subset == null) {
            throw new ResourceNotFoundException("Tiled collection " + this.collectionId + " does not support tile matrix set " + this.tileMatrixSetId);
        }
        LayerMetaInformation metadata = this.tileLayer.getMetaInformation();
        tileJSON.setFormat(this.tileFormat);
        BoundingBox bounds = subset.getCoverageBestFitBounds();
        if (bounds != null) {
            ReferencedEnvelope envelope = new ReferencedEnvelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY(), CRS.decode((String)subset.getSRS().toString()));
            ReferencedEnvelope wgs84Envelope = envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            ReferencedEnvelope intersection = wgs84Envelope.intersection(new Envelope(-180.0, 180.0, -90.0, 90.0));
            tileJSON.setBounds(new double[]{intersection.getMinX(), intersection.getMinY(), intersection.getMaxX(), intersection.getMaxY()});
            long[] coverageBestFit = subset.getCoverageBestFit();
            if (coverageBestFit != null) {
                tileJSON.setCenter(new double[]{intersection.getMedian(0), intersection.getMedian(1), coverageBestFit[4]});
            }
        }
        APIRequestInfo requestInfo = APIRequestInfo.get();
        String baseURL = requestInfo.getBaseURL();
        boolean bl = isVector = this.styleId == null && this.isVector(this.tileFormat);
        if (this.styleId != null) {
            tilesURL = ResponseUtils.buildURL((String)baseURL, (String)("ogc/tiles/v1/collections/" + ResponseUtils.urlEncode((String)this.collectionId, (char[])new char[0]) + "/styles/" + ResponseUtils.urlEncode((String)this.styleId, (char[])new char[0]) + "/map/tiles/" + this.tileMatrixSetId + "/{z}/{y}/{x}"), Collections.singletonMap("f", this.tileFormat), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        } else {
            String tilesPrefix = isVector ? "" : "/map";
            tilesURL = ResponseUtils.buildURL((String)baseURL, (String)("ogc/tiles/v1/collections/" + ResponseUtils.urlEncode((String)this.collectionId, (char[])new char[0]) + tilesPrefix + "/tiles/" + this.tileMatrixSetId + "/{z}/{y}/{x}"), Collections.singletonMap("f", this.tileFormat), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }
        tileJSON.setTiles(new String[]{tilesURL});
        if (!(this.tileLayer instanceof GeoServerTileLayer)) {
            TileJSONProvider tileJSONProvider = (TileJSONProvider)this.tileLayer;
            if (tileJSONProvider.supportsTileJSON()) {
                tileJSON = tileJSONProvider.getTileJSON();
                tileJSON.setTiles(new String[]{tilesURL});
                tileJSON.setFormat(this.tileFormat);
                return tileJSON;
            }
            throw new InvalidParameterValueException("TileJSON metadata is not supported on this layer");
        }
        GeoServerTileLayer gtl = (GeoServerTileLayer)this.tileLayer;
        PublishedInfo published = gtl.getPublishedInfo();
        AttributionInfo attributionInfo = published.getAttribution();
        if (attributionInfo != null) {
            tileJSON.setAttribution(attributionInfo.getTitle());
        }
        if ((description = published.getAbstract()) == null && metadata != null) {
            description = metadata.getDescription();
        }
        tileJSON.setDescription(description);
        if (published instanceof LayerInfo) {
            this.decorateTileJSON((LayerInfo)published, tileJSON, isVector, subset);
        } else if (published instanceof LayerGroupInfo) {
            tileJSON = this.decorateTileJSON((LayerGroupInfo)published, tileJSON, isVector, subset);
        }
        this.setTileJSONZoomLevels(tileJSON, subset);
        return tileJSON;
    }

    private boolean isVector(String tileFormat) {
        MimeType format = null;
        if (tileFormat != null) {
            try {
                format = MimeType.createFromFormat((String)tileFormat);
            }
            catch (MimeException mimeException) {
                // empty catch block
            }
        }
        return format != null ? format.isVector() : false;
    }

    private TileJSON decorateTileJSON(LayerGroupInfo group, TileJSON tileJSON, boolean vector, GridSubset subset) throws TransformException, FactoryException, IOException {
        ReferencedEnvelope groupBounds = group.getBounds();
        ReferencedEnvelope bounds = groupBounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        tileJSON.setBounds(new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()});
        if (vector) {
            LayerGroupHelper helper = new LayerGroupHelper(group);
            List layers = helper.allLayers();
            ArrayList<VectorLayerMetadata> metadatas = new ArrayList<VectorLayerMetadata>();
            for (LayerInfo layer : layers) {
                VectorLayerMetadata metadata = this.getVectorLayerMetadata(layer, subset);
                if (metadata == null) continue;
                metadatas.add(metadata);
            }
            tileJSON.setLayers(metadatas);
        }
        return tileJSON;
    }

    private void decorateTileJSON(LayerInfo published, TileJSON tileJSON, boolean vector, GridSubset subset) throws IOException {
        VectorLayerMetadata layerMetadata;
        ResourceInfo resource = published.getResource();
        ReferencedEnvelope bounds = resource.getLatLonBoundingBox();
        tileJSON.setBounds(new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()});
        if (vector && (layerMetadata = this.getVectorLayerMetadata(published, subset)) != null) {
            tileJSON.setLayers(Arrays.asList(layerMetadata));
        }
    }

    private VectorLayerMetadata getVectorLayerMetadata(LayerInfo layerInfo, GridSubset subset) throws IOException {
        ResourceInfo ri = layerInfo.getResource();
        if (!(ri instanceof FeatureTypeInfo)) {
            return null;
        }
        FeatureTypeInfo fti = (FeatureTypeInfo)ri;
        VectorLayerMetadata metadata = new VectorLayerMetadata();
        metadata.setId(fti.getName());
        metadata.setDescription(fti.getAbstract());
        FeatureType featureType = fti.getFeatureType();
        if (!(featureType instanceof SimpleFeatureType)) {
            return null;
        }
        SimpleFeatureType simple = (SimpleFeatureType)featureType;
        if (simple.getGeometryDescriptor() != null) {
            Class binding = simple.getGeometryDescriptor().getType().getBinding();
            if (LineString.class.isAssignableFrom(binding) || MultiLineString.class.isAssignableFrom(binding)) {
                metadata.setGeometryType(VectorLayerMetadata.GeometryType.line);
            } else if (Polygon.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding)) {
                metadata.setGeometryType(VectorLayerMetadata.GeometryType.polygon);
            } else if (Point.class.isAssignableFrom(binding) || MultiPoint.class.isAssignableFrom(binding)) {
                metadata.setGeometryType(VectorLayerMetadata.GeometryType.point);
            }
        }
        Map<String, String> fields = simple.getAttributeDescriptors().stream().filter(d -> !(d instanceof GeometryDescriptor)).collect(Collectors.toMap(d -> d.getLocalName(), d -> this.toTypeName(d.getType())));
        metadata.setFields(fields);
        NumberRange<Integer> zoomRange = this.findLayerZoomLevel(layerInfo, subset);
        metadata.setMinZoom((Integer)zoomRange.getMinValue());
        metadata.setMaxZoom((Integer)zoomRange.getMaxValue());
        return metadata;
    }

    private String toTypeName(org.geotools.api.feature.type.AttributeType type) {
        return AttributeType.fromClass((Class)type.getBinding()).getType();
    }

    private NumberRange<Integer> findLayerZoomLevel(LayerInfo layerInfo, GridSubset subset) throws IOException {
        NumberRange scaleRange = CapabilityUtil.searchMinMaxScaleDenominator((LayerInfo)layerInfo);
        double minScale = scaleRange.getMinimum();
        double maxScale = scaleRange.getMaximum();
        GridSet gridSet = subset.getGridSet();
        int startLevel = Optional.ofNullable(subset.getMinCachedZoom()).orElse(subset.getZoomStart());
        int endLevel = Optional.ofNullable(subset.getMaxCachedZoom()).orElse(subset.getZoomStop());
        int limit = startLevel + gridSet.getNumLevels();
        double startScale = gridSet.getGrid(startLevel).getScaleDenominator();
        double endScale = gridSet.getGrid(endLevel).getScaleDenominator();
        boolean foundStartLevel = maxScale > startScale;
        boolean foundEndLevel = minScale < endScale;
        double maxScaleDist = Double.MAX_VALUE;
        double minScaleDist = Double.MAX_VALUE;
        for (int zoomLevel = startLevel; zoomLevel < limit; ++zoomLevel) {
            double distance;
            Grid grid = gridSet.getGrid(zoomLevel);
            double gridScale = grid.getScaleDenominator();
            if (!foundStartLevel && (distance = Math.abs(gridScale - maxScale)) < maxScaleDist && gridScale < maxScale) {
                startLevel = zoomLevel;
                maxScaleDist = distance;
            }
            if (foundEndLevel || !((distance = gridScale - minScale) < minScaleDist) || !(gridScale > minScale)) continue;
            endLevel = zoomLevel;
            minScaleDist = distance;
        }
        return NumberRange.create((int)startLevel, (int)endLevel);
    }

    private void setTileJSONZoomLevels(TileJSON tileJSON, GridSubset subset) {
        List layersMetadata = tileJSON.getLayers();
        int globalMinZoomLevel = Optional.ofNullable(subset.getMinCachedZoom()).orElse(subset.getZoomStart());
        int globalMaxZoomLevel = Optional.ofNullable(subset.getMaxCachedZoom()).orElse(subset.getZoomStop());
        if (layersMetadata != null && !layersMetadata.isEmpty()) {
            globalMinZoomLevel = layersMetadata.stream().map(m -> m.getMinZoom()).min(Integer::compare).get();
            globalMaxZoomLevel = layersMetadata.stream().map(m -> m.getMaxZoom()).max(Integer::compare).get();
        }
        tileJSON.setMinZoom(Integer.valueOf(globalMinZoomLevel));
        tileJSON.setMaxZoom(Integer.valueOf(globalMaxZoomLevel));
    }
}

