/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.google.common.collect.Streams;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.OpenAPIBuilder;
import org.geoserver.ogcapi.v1.tiles.TiledCollectionsDocument;
import org.geoserver.ogcapi.v1.tiles.TilesService;
import org.geoserver.ogcapi.v1.tiles.TilesServiceInfo;

public class TilesAPIBuilder
extends OpenAPIBuilder<TilesServiceInfo> {
    private final GWC gwc;

    public TilesAPIBuilder(GWC gwc) {
        super(TilesServiceInfo.class, "openapi.yaml", "Tiles API", TilesService.class);
        this.gwc = gwc;
    }

    public OpenAPI build(TilesServiceInfo service) throws IOException {
        OpenAPI api = super.build((ServiceInfo)service);
        this.declareGetResponseFormats(api, "/collections", TiledCollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}", TiledCollectionsDocument.class);
        api.externalDocs(new ExternalDocumentation().description("Tiles specification").url("https://github.com/opengeospatial/OGC-API-Map-Tiles"));
        Map parameters = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)parameters.get("collectionId");
        List validCollectionIds = Streams.stream((Iterable)this.gwc.getTileLayers()).map(tl -> tl instanceof GeoServerTileLayer ? ((GeoServerTileLayer)tl).getContextualName() : tl.getName()).collect(Collectors.toList());
        collectionId.getSchema().setEnum(validCollectionIds);
        return api;
    }
}

