/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.SampleDataProvider;
import org.geoserver.ogcapi.v1.tiles.TilesService;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geowebcache.mime.MimeType;
import org.springframework.stereotype.Component;

@Component
public class TilesSampleDataProvider
implements SampleDataProvider {
    private final GWC gwc;
    private final TilesService service;

    TilesSampleDataProvider(GWC gwc, TilesService service) {
        this.gwc = gwc;
        this.service = service;
    }

    public List<Link> getSampleData(LayerInfo layer) {
        GeoServerTileLayer tileLayer;
        if (layer.getResource() instanceof ResourceInfo && this.service.getService().isEnabled() && (tileLayer = this.gwc.getTileLayer((CatalogInfo)layer)) != null) {
            List mimeTypes = tileLayer.getMimeTypes();
            return mimeTypes.stream().filter(m -> m.isVector()).map(m -> this.buildSampleDataLink(layer, (MimeType)m)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Link buildSampleDataLink(LayerInfo layer, MimeType m) {
        String href = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/tiles/v1/collections/" + ResponseUtils.urlEncode((String)(layer.prefixedName() + "/tiles"), (char[])new char[0])), Collections.singletonMap("f", m.getFormat()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        return new Link(href, "tiles", m.getFormat(), "Tiles as " + m.getFormat());
    }
}

