/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.v1.tiles.TileJSONBuilder;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.mbtiles.layer.MBTilesLayer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TileJSONBuilderTest {
    @Test
    public void testMBTiles() throws Exception {
        try (MockedStatic staticRequestInfos = Mockito.mockStatic(APIRequestInfo.class);){
            APIRequestInfo requestInfo = (APIRequestInfo)Mockito.mock(APIRequestInfo.class);
            Mockito.when((Object)APIRequestInfo.get()).thenReturn((Object)requestInfo);
            staticRequestInfos.when(APIRequestInfo::get).thenReturn((Object)requestInfo);
            Mockito.when((Object)requestInfo.getBaseURL()).thenReturn((Object)"http://localhost:8081/geoserver");
            MBTilesLayer mbTilesLayer = (MBTilesLayer)Mockito.mock(MBTilesLayer.class);
            LayerMetaInformation metaInformation = (LayerMetaInformation)Mockito.mock(LayerMetaInformation.class);
            GridSubset subset = (GridSubset)Mockito.mock(GridSubset.class);
            Mockito.when((Object)mbTilesLayer.getName()).thenReturn((Object)"countries");
            Mockito.when((Object)mbTilesLayer.getGridSubset(ArgumentMatchers.anyString())).thenReturn((Object)subset);
            Mockito.when((Object)mbTilesLayer.getMetaInformation()).thenReturn((Object)metaInformation);
            Mockito.when((Object)mbTilesLayer.supportsTileJSON()).thenReturn((Object)true);
            TileJSON tileJSON = new TileJSON();
            tileJSON.setName("countries");
            tileJSON.setDescription("Natural Earth Data with .shp data from  TileMill");
            tileJSON.setAttribution("Natural Earth Data");
            tileJSON.setMinZoom(Integer.valueOf(0));
            tileJSON.setMaxZoom(Integer.valueOf(6));
            tileJSON.setScheme("xyz");
            Mockito.when((Object)mbTilesLayer.getTileJSON()).thenReturn((Object)tileJSON);
            TileJSONBuilder tileJSONBuilder = new TileJSONBuilder("countries", "application/vnd.mapbox-vector-tile", "EPSG:900913", (TileLayer)mbTilesLayer);
            TileJSON actualJson = tileJSONBuilder.build();
            Assert.assertEquals((Object)"countries", (Object)actualJson.getName());
            Assert.assertEquals((Object)"http://localhost:8081/geoserver/ogc/tiles/v1/collections/countries/tiles/EPSG:900913/{z}/{y}/{x}?f=application%2Fvnd.mapbox-vector-tile", (Object)actualJson.getTiles()[0]);
            Assert.assertEquals((Object)"Natural Earth Data with .shp data from  TileMill", (Object)actualJson.getDescription());
            Assert.assertEquals((Object)"Natural Earth Data", (Object)tileJSON.getAttribution());
            Assert.assertEquals((long)0L, (long)tileJSON.getMinZoom().longValue());
            Assert.assertEquals((long)6L, (long)tileJSON.getMaxZoom().longValue());
            Assert.assertEquals((Object)"xyz", (Object)tileJSON.getScheme());
        }
    }
}

