/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.tiles;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ogcapi.v1.tiles.TileMatrixSetLimit;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wms.WMS;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.meta.TileJSON;
import org.geowebcache.mime.MimeType;

public class Tileset
extends AbstractDocument {
    public static final String TILE_REL = "item";
    private final String styleId;
    private final String tileMatrixId;
    String tileMatrixSetURI;
    String tileMatrixSetDefinition;
    DataType dataType;
    private final String gridSubsetId;
    List<TileMatrixSetLimit> tileMatrixSetLimits = new ArrayList<TileMatrixSetLimit>();

    public Tileset(WMS wms, TileLayer tileLayer, DataType dataType, String tileMatrixId, boolean addDetails) {
        this(wms, tileLayer, dataType, tileMatrixId, null, addDetails);
    }

    public Tileset(WMS wms, TileLayer tileLayer, DataType dataType, String tileMatrixId, String styleId, boolean addDetails) {
        boolean hasLimits;
        GridSubset gridSubset = tileLayer.getGridSubset(tileMatrixId);
        this.gridSubsetId = tileMatrixId;
        this.dataType = dataType;
        this.styleId = styleId;
        this.tileMatrixId = tileMatrixId;
        String baseURL = APIRequestInfo.get().getBaseURL();
        this.tileMatrixSetDefinition = this.tileMatrixSetURI = ResponseUtils.buildURL((String)baseURL, (String)("ogc/tiles/v1/tileMatrixSets/" + ResponseUtils.urlEncode((String)gridSubset.getGridSet().getName(), (char[])new char[0])), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        boolean bl = hasLimits = !gridSubset.fullGridSetCoverage() || gridSubset.getGridSet().getNumLevels() != gridSubset.getZoomStop() - gridSubset.getZoomStart() + 1;
        if (hasLimits && addDetails) {
            String[] levelNames = gridSubset.getGridNames();
            long[][] wmtsLimits = gridSubset.getWMTSCoverages();
            for (int i = 0; i < levelNames.length; ++i) {
                TileMatrixSetLimit limit = new TileMatrixSetLimit(levelNames[i], wmtsLimits[i][1], wmtsLimits[i][3], wmtsLimits[i][0], wmtsLimits[i][2]);
                this.validateLimits(limit, gridSubset, i);
                this.tileMatrixSetLimits.add(limit);
            }
        }
        String string = this.id = tileLayer instanceof GeoServerTileLayer ? ((GeoServerTileLayer)tileLayer).getContextualName() : tileLayer.getName();
        if (dataType == DataType.vector) {
            this.addSelfLinks("ogc/tiles/v1/collections/" + this.id + "/tiles/" + tileMatrixId);
        } else if (dataType == DataType.map) {
            if (styleId == null) {
                this.addSelfLinks("ogc/tiles/v1/collections/" + this.id + "/map/tiles/" + tileMatrixId);
            } else {
                this.addSelfLinks("ogc/tiles/v1/collections/" + this.id + "/styles/" + styleId + "/map/tiles/" + tileMatrixId);
            }
        } else {
            throw new IllegalArgumentException("Cannot handle data type: " + dataType);
        }
        if (addDetails) {
            List tileTypes = tileLayer.getMimeTypes();
            if (dataType == DataType.vector) {
                tileTypes.stream().filter(mt -> mt.isVector()).collect(Collectors.toList()).forEach(dataFormat -> this.addTilesLinkForFormat(this.id, baseURL, dataFormat.getFormat(), ResponseUtils.appendPath((String[])new String[]{"/tiles/", tileMatrixId, "/{tileMatrix}/{tileRow}/{tileCol}"}), TILE_REL));
                new LinksBuilder(TileJSON.class, "ogc/tiles/v1/collections").segment(this.id, true).segment("tiles").segment(tileMatrixId, true).segment("metadata").title("Tiles metadata as ").rel("describedBy").classification("metadata").updater((m, l) -> l.setTemplated(Boolean.valueOf(true))).add((AbstractDocument)this);
            } else if (dataType == DataType.map) {
                List<MimeType> imageFormats = tileTypes.stream().filter(mt -> !mt.isVector()).collect(Collectors.toList());
                Object base = styleId != null ? "/styles/" + styleId + "/map/tiles/" : "/map/tiles/";
                imageFormats.forEach(arg_0 -> this.lambda$new$4(baseURL, (String)base, tileMatrixId, arg_0));
                wms.getAvailableFeatureInfoFormats().forEach(arg_0 -> this.lambda$new$5(baseURL, (String)base, tileMatrixId, arg_0));
                new LinksBuilder(TileJSON.class, "ogc/tiles/v1/collections/").segment(this.id, true).segment((String)base).segment(tileMatrixId, true).segment("metadata").title("Tiles metadata as ").rel("describedBy").classification("metadata").updater((m, l) -> {
                    l.setTemplated(Boolean.valueOf(true));
                    l.setHref(l.getHref() + "&tileFormat={tileFormat}");
                }).add((AbstractDocument)this);
            } else {
                throw new IllegalArgumentException("Tiles of this type are not yet supported: " + dataType);
            }
        }
    }

    private void validateLimits(TileMatrixSetLimit limit, GridSubset gridSubset, int zoomLevel) {
        long numTilesHeight = gridSubset.getGridSet().getGrid(zoomLevel).getNumTilesHigh();
        long numTilesWide = gridSubset.getGridSet().getGrid(zoomLevel).getNumTilesWide();
        if (limit.getMinTileRow() < 0L) {
            limit.setMinTileRow(0L);
        }
        if (limit.getMinTileCol() < 0L) {
            limit.setMinTileCol(0L);
        }
        if (limit.getMaxTileRow() > numTilesHeight - 1L) {
            limit.setMaxTileRow(numTilesHeight - 1L);
        }
        if (limit.getMaxTileCol() > numTilesWide - 1L) {
            limit.setMaxTileCol(numTilesWide - 1L);
        }
    }

    public String getTileMatrixSetURI() {
        return this.tileMatrixSetURI;
    }

    public void setTileMatrixSetURI(String tileMatrixSetURI) {
        this.tileMatrixSetURI = tileMatrixSetURI;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<TileMatrixSetLimit> getTileMatrixSetLimits() {
        return this.tileMatrixSetLimits;
    }

    public void setTileMatrixSetLimits(List<TileMatrixSetLimit> tileMatrixSetLimits) {
        this.tileMatrixSetLimits = tileMatrixSetLimits;
    }

    public String getTileMatrixSetDefinition() {
        return this.tileMatrixSetDefinition;
    }

    public void setTileMatrixSetDefinition(String tileMatrixSetDefinition) {
        this.tileMatrixSetDefinition = tileMatrixSetDefinition;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @JsonIgnore
    public String getGridSubsetId() {
        return this.gridSubsetId;
    }

    public String toString() {
        return "Tileset{tileMatrixSetURI='" + this.tileMatrixSetURI + "', tileMatrixSetDefinition='" + this.tileMatrixSetDefinition + "', dataType=" + this.dataType + ", tileMatrixSetLimits=" + this.tileMatrixSetLimits + "}";
    }

    protected final void addTilesLinkForFormat(String layerName, String baseURL, String format, String path, String rel) {
        String apiUrl = ResponseUtils.buildURL((String)baseURL, (String)("ogc/tiles/v1/collections/" + ResponseUtils.urlEncode((String)layerName, (char[])new char[0]) + path), Collections.singletonMap("f", format), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Link link = new Link(apiUrl, rel, format, layerName + " tiles as " + format);
        link.setTemplated(Boolean.valueOf(true));
        this.addLink(link);
    }

    @JsonIgnore
    public String getStyleId() {
        return this.styleId;
    }

    @JsonIgnore
    public String getTileMatrixId() {
        return this.tileMatrixId;
    }

    private /* synthetic */ void lambda$new$5(String baseURL, String base, String tileMatrixId, String infoFormat) {
        this.addTilesLinkForFormat(this.id, baseURL, infoFormat, ResponseUtils.appendPath((String[])new String[]{base, tileMatrixId, "/{tileMatrix}/{tileRow}/{tileCol}/info"}), "info");
    }

    private /* synthetic */ void lambda$new$4(String baseURL, String base, String tileMatrixId, MimeType imageFormat) {
        this.addTilesLinkForFormat(this.id, baseURL, imageFormat.getFormat(), ResponseUtils.appendPath((String[])new String[]{base, tileMatrixId, "/{tileMatrix}/{tileRow}/{tileCol}"}), TILE_REL);
    }

    public static enum DataType {
        map,
        vector,
        coverage;

    }
}

